/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchBuilder;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketchIterator;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketches;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="ArrayOfDoublesSketchToQuantilesSketch", value="_FUNC_(sketch, column, k)", extended="Returns a quanitles DoublesSketch constructed from a given column of double values from a given ArrayOfDoublesSketch using parameter k that determines the accuracy and size of the quantiles sketch. The column number is optional (the default is 1). The parameter k is optional (the default is defined in the sketch library). The result is a serialized quantiles sketch.")
public class ArrayOfDoublesSketchToQuantilesSketchUDF
extends UDF {
    public BytesWritable evaluate(BytesWritable serializedSketch) {
        return this.evaluate(serializedSketch, 1, 0);
    }

    public BytesWritable evaluate(BytesWritable serializedSketch, int column) {
        return this.evaluate(serializedSketch, column, 0);
    }

    public BytesWritable evaluate(BytesWritable serializedSketch, int column, int k) {
        if (serializedSketch == null) {
            return null;
        }
        ArrayOfDoublesSketch sketch = ArrayOfDoublesSketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch));
        if (column < 1) {
            throw new IllegalArgumentException("Column number must be greater than zero. Received: " + column);
        }
        if (column > sketch.getNumValues()) {
            throw new IllegalArgumentException("Column number " + column + " is out of range. The given sketch has " + sketch.getNumValues() + " columns");
        }
        DoublesSketchBuilder builder = DoublesSketch.builder();
        if (k > 0) {
            builder.setK(k);
        }
        UpdateDoublesSketch qs = builder.build();
        ArrayOfDoublesSketchIterator it = sketch.iterator();
        while (it.next()) {
            qs.update(it.getValues()[column - 1]);
        }
        return new BytesWritable(qs.compact().toByteArray());
    }
}

