/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;

public final class TestUtil {
    private static final String userDir = System.getProperty("user.dir");
    public static final String GENERATE_JAVA_FILES = "generate_java_files";
    public static final String CHECK_CPP_FILES = "check_cpp_files";
    public static final String CHECK_CPP_HISTORICAL_FILES = "check_cpp_historical_files";
    public static final Path javaPath = TestUtil.createPath("serialization_test_data/java_generated_files");
    public static final Path cppPath = TestUtil.createPath("serialization_test_data/cpp_generated_files");
    private static final int BUF_SIZE = 8192;

    private static Path createPath(String projectLocalDir) {
        try {
            return Files.createDirectories(Paths.get(userDir, projectLocalDir), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new SketchesArgumentException(e.getCause().toString());
        }
    }

    public static File getResourceFile(String shortFileName) {
        File file;
        block30: {
            Objects.requireNonNull(shortFileName, "input parameter 'String shortFileName' cannot be null.");
            String slashName = shortFileName.charAt(0) == '/' ? shortFileName : '/' + shortFileName;
            URL url = TestUtil.class.getResource(slashName);
            Objects.requireNonNull(url, "resource " + slashName + " returns null URL.");
            file = TestUtil.createTempFile(slashName);
            if (url.getProtocol().equals("jar")) {
                try (InputStream input = TestUtil.class.getResourceAsStream(slashName);
                     FileOutputStream out = new FileOutputStream(file);){
                    Objects.requireNonNull(input, "InputStream  is null.");
                    int numRead = 0;
                    byte[] buf = new byte[1024];
                    while ((numRead = input.read(buf)) != -1) {
                        ((OutputStream)out).write(buf, 0, numRead);
                    }
                    break block30;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            file = new File(TestUtil.getResourcePath(url));
        }
        if (!file.setReadable(false, true)) {
            throw new IllegalStateException("Failed to set owner only 'Readable' on file");
        }
        if (!file.setWritable(false, false)) {
            throw new IllegalStateException("Failed to set everyone 'Not Writable' on file");
        }
        return file;
    }

    public static byte[] getResourceBytes(String shortFileName) {
        byte[] out;
        block17: {
            Objects.requireNonNull(shortFileName, "input parameter 'String shortFileName' cannot be null.");
            String slashName = shortFileName.charAt(0) == '/' ? shortFileName : '/' + shortFileName;
            URL url = TestUtil.class.getResource(slashName);
            Objects.requireNonNull(url, "resource " + slashName + " returns null URL.");
            if (url.getProtocol().equals("jar")) {
                try (InputStream input = TestUtil.class.getResourceAsStream(slashName);){
                    out = TestUtil.readAllBytesFromInputStream(input);
                    break block17;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                out = Files.readAllBytes(Paths.get(TestUtil.getResourcePath(url), new String[0]));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return out;
    }

    public static byte[] readAllBytesFromInputStream(InputStream in) {
        return TestUtil.readBytesFromInputStream(Integer.MAX_VALUE, in);
    }

    public static byte[] readBytesFromInputStream(int numBytesToRead, InputStream in) {
        int chunkCnt;
        if (numBytesToRead < 0) {
            throw new IllegalArgumentException("numBytesToRead must be positive or zero.");
        }
        ArrayList<byte[]> buffers = null;
        byte[] result = null;
        int totalBytesRead = 0;
        int remaining = numBytesToRead;
        do {
            byte[] partialBuffer = new byte[Math.min(remaining, 8192)];
            int numRead = 0;
            try {
                while ((chunkCnt = in.read(partialBuffer, numRead, Math.min(partialBuffer.length - numRead, remaining))) > 0) {
                    numRead += chunkCnt;
                    remaining -= chunkCnt;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (numRead <= 0) continue;
            if (0x7FFFFFF7 - totalBytesRead < numRead) {
                throw new IllegalArgumentException("Input stream is larger than what can be safely allocated as a byte[] in some VMs.");
            }
            totalBytesRead += numRead;
            if (result == null) {
                result = partialBuffer;
                continue;
            }
            if (buffers == null) {
                buffers = new ArrayList<byte[]>();
                buffers.add(result);
            }
            buffers.add(partialBuffer);
        } while (chunkCnt >= 0 && remaining > 0);
        if (buffers == null) {
            byte[] out = result == null ? new byte[]{} : (result.length == totalBytesRead ? result : Arrays.copyOf(result, totalBytesRead));
            return out;
        }
        result = new byte[totalBytesRead];
        int offset = 0;
        remaining = totalBytesRead;
        for (byte[] b : buffers) {
            int count = Math.min(b.length, remaining);
            System.arraycopy(b, 0, result, offset, count);
            offset += count;
            remaining -= count;
        }
        return result;
    }

    private static String getResourcePath(URL url) {
        try {
            URI uri = url.toURI();
            String path = uri.isAbsolute() ? Paths.get(uri).toAbsolutePath().toString() : uri.getPath();
            return path;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot find resource: " + url.toString() + Util.LS + e);
        }
    }

    private static File createTempFile(String shortFileName) {
        File file;
        String name;
        String suffix;
        String resName = shortFileName.charAt(0) == '/' ? shortFileName.substring(1) : shortFileName;
        int lastIdx = resName.length() - 1;
        int lastIdxOfDot = resName.lastIndexOf(46);
        if (lastIdxOfDot == -1) {
            suffix = ".tmp";
            name = resName;
        } else if (lastIdxOfDot == lastIdx) {
            suffix = ".tmp";
            name = resName.substring(0, lastIdxOfDot);
        } else {
            suffix = resName.substring(lastIdxOfDot);
            name = resName.substring(0, lastIdxOfDot);
        }
        try {
            file = File.createTempFile("temp_" + name, suffix);
            if (!file.setReadable(false, true)) {
                throw new IllegalStateException("Failed to set only owner 'Readable' on file");
            }
            if (!file.setWritable(false, true)) {
                throw new IllegalStateException("Failed to set only owner 'Writable' on file");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return file;
    }
}

