/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.cpc;

import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.cpc.CpcUnion;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CpcUnionTest {
    @Test
    public void checkExceptions() {
        CpcSketch sk = new CpcSketch(10, 1L);
        CpcUnion union = new CpcUnion();
        try {
            union.update(sk);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        sk = null;
        union.update(sk);
        union = null;
        try {
            CpcUnion.getBitMatrix((CpcUnion)union);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
    }

    @Test
    public void checkGetters() {
        int lgK = 10;
        CpcUnion union = new CpcUnion(lgK);
        Assert.assertEquals((int)union.getLgK(), (int)lgK);
        Assert.assertEquals((long)union.getNumCoupons(), (long)0L);
        CpcSketch sk = new CpcSketch(lgK);
        for (int i = 0; i <= 4 << lgK; ++i) {
            sk.update((long)i);
        }
        union.update(sk);
        Assert.assertTrue((union.getNumCoupons() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((CpcUnion.getBitMatrix((CpcUnion)union) != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)Family.CPC, (Object)CpcUnion.getFamily());
    }

    @Test
    public void checkReduceK() {
        CpcUnion union = new CpcUnion(12);
        CpcSketch sk = new CpcSketch(11);
        int u = 1;
        sk.update((long)u);
        union.update(sk);
        CpcUnion.getBitMatrix((CpcUnion)union);
        CpcSketch sk2 = new CpcSketch(10);
        int shTrans = 48;
        while (sk2.numCoupons < (long)shTrans) {
            sk2.update((long)(++u));
        }
        union.update(sk2);
        CpcSketch sk3 = new CpcSketch(9);
        sk3.update((long)(++u));
        union.update(sk3);
        CpcSketch sk4 = new CpcSketch(8);
        sk4.update((long)(++u));
        union.update(sk4);
    }
}

