/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.cpc;

import java.io.IOException;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.cpc.CpcUnion;
import org.apache.datasketches.pig.cpc.DataToSketch;
import org.apache.datasketches.pig.cpc.UnionSketch;
import org.apache.log4j.Logger;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

abstract class AlgebraicFinal
extends EvalFunc<DataByteArray> {
    private final int lgK_;
    private final long seed_;
    private DataByteArray emptySketch_;
    private boolean isFirstCall_ = true;

    public AlgebraicFinal(int lgK, long seed) {
        this.lgK_ = lgK;
        this.seed_ = seed;
    }

    public DataByteArray exec(Tuple inputTuple) throws IOException {
        DataByteArray dba;
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Algebraic was used");
            this.isFirstCall_ = false;
        }
        if ((dba = AlgebraicFinal.process(inputTuple, this.lgK_, this.seed_, this.isInputRaw())) == null) {
            return this.getEmptySketch();
        }
        return dba;
    }

    static DataByteArray process(Tuple inputTuple, int lgK, long seed, boolean isInputRaw) throws IOException {
        if (inputTuple == null || inputTuple.size() == 0) {
            return null;
        }
        CpcSketch sketch = null;
        CpcUnion union = null;
        DataBag outerBag = (DataBag)inputTuple.get(0);
        if (outerBag == null) {
            return null;
        }
        for (Tuple dataTuple : outerBag) {
            Object f0 = dataTuple.get(0);
            if (f0 == null) continue;
            if (f0 instanceof DataBag) {
                DataBag innerBag = (DataBag)f0;
                if (innerBag.size() == 0L) continue;
                if (isInputRaw) {
                    if (sketch == null) {
                        sketch = new CpcSketch(lgK, seed);
                    }
                    DataToSketch.updateSketch(innerBag, sketch);
                    continue;
                }
                if (union == null) {
                    union = new CpcUnion(lgK, seed);
                }
                UnionSketch.updateUnion(innerBag, union, seed);
                continue;
            }
            if (f0 instanceof DataByteArray) {
                DataByteArray dba = (DataByteArray)f0;
                if (union == null) {
                    union = new CpcUnion(lgK, seed);
                }
                union.update(CpcSketch.heapify((byte[])dba.get(), (long)seed));
                continue;
            }
            throw new IllegalArgumentException("dataTuple.Field0 is not a DataBag or DataByteArray: " + f0.getClass().getName());
        }
        if (sketch != null && union != null) {
            union.update(sketch);
            sketch = null;
        }
        if (sketch != null) {
            return new DataByteArray(sketch.toByteArray());
        }
        if (union != null) {
            return new DataByteArray(union.getResult().toByteArray());
        }
        return null;
    }

    abstract boolean isInputRaw();

    private DataByteArray getEmptySketch() {
        if (this.emptySketch_ == null) {
            this.emptySketch_ = new DataByteArray(new CpcSketch(this.lgK_, this.seed_).toByteArray());
        }
        return this.emptySketch_;
    }
}

