/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.theta;

import java.io.IOException;
import org.apache.datasketches.pig.theta.PigUtil;
import org.apache.datasketches.theta.Sketch;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.Tuple;

public class SketchToString
extends EvalFunc<String> {
    private boolean detailOut = false;
    private final long seed_;

    public SketchToString() {
        this(false, 9001L);
    }

    public SketchToString(String outputDetailStr) {
        this(outputDetailStr.substring(0, 1).equalsIgnoreCase("T"), 9001L);
    }

    public SketchToString(String outputDetailStr, String seedStr) {
        this(outputDetailStr.substring(0, 1).equalsIgnoreCase("T"), Long.parseLong(seedStr));
    }

    public SketchToString(boolean outputDetail, long seed) {
        this.detailOut = outputDetail;
        this.seed_ = seed;
    }

    public String exec(Tuple sketchTuple) throws IOException {
        if (sketchTuple == null || sketchTuple.size() == 0) {
            return null;
        }
        Sketch sketch = PigUtil.tupleToSketch(sketchTuple, this.seed_);
        return sketch.toString(true, this.detailOut, 8, true);
    }
}

