/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import java.io.IOException;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.tuple.ArrayOfDoublesSketchStats;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketches;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class ArrayOfDoublesSketchToVariances
extends EvalFunc<Tuple> {
    public Tuple exec(Tuple input) throws IOException {
        if (input == null || input.size() == 0) {
            return null;
        }
        DataByteArray dba = (DataByteArray)input.get(0);
        ArrayOfDoublesSketch sketch = ArrayOfDoublesSketches.wrapSketch((Memory)Memory.wrap((byte[])dba.get()));
        if (sketch.getRetainedEntries() < 1) {
            return null;
        }
        SummaryStatistics[] summaries = ArrayOfDoublesSketchStats.sketchToSummaryStatistics(sketch);
        Tuple variances = TupleFactory.getInstance().newTuple(sketch.getNumValues());
        for (int i = 0; i < sketch.getNumValues(); ++i) {
            variances.set(i, (Object)summaries[i].getVariance());
        }
        return variances;
    }
}

