/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.control;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.configuration.Configuration;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.UnitConfiguration;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.controller.OutletReference;
import org.apache.torque.generator.configuration.controller.Output;
import org.apache.torque.generator.configuration.outlet.OutletConfiguration;
import org.apache.torque.generator.control.ControllerException;
import org.apache.torque.generator.control.ControllerHelper;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.control.existingtargetstrategy.AppendToTargetFileStrategy;
import org.apache.torque.generator.control.existingtargetstrategy.ExistingTargetStrategy;
import org.apache.torque.generator.control.existingtargetstrategy.MergeTargetFileStrategy;
import org.apache.torque.generator.control.existingtargetstrategy.ReplaceTargetFileStrategy;
import org.apache.torque.generator.control.existingtargetstrategy.SkipExistingTargetFileStrategy;
import org.apache.torque.generator.outlet.Outlet;
import org.apache.torque.generator.outlet.OutletResult;
import org.apache.torque.generator.source.Source;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceException;
import org.apache.torque.generator.source.SourcePath;
import org.apache.torque.generator.source.SourceProcessConfiguration;
import org.apache.torque.generator.source.SourceProvider;
import org.apache.torque.generator.source.SourceTransformerDefinition;
import org.apache.torque.generator.source.skipDecider.SkipDecider;
import org.apache.torque.generator.source.transform.SourceTransformer;
import org.apache.torque.generator.source.transform.SourceTransformerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller {
    private static Log log = LogFactory.getLog(Controller.class);
    private static final List<ExistingTargetStrategy> EXISTING_TARGET_STRATEGIES;

    public void run(List<UnitDescriptor> unitDescriptors) throws GeneratorException {
        this.initLogging();
        Configuration configuration = this.readConfiguration(unitDescriptors);
        List<UnitConfiguration> unitConfigurations = configuration.getUnitConfigurations();
        ControllerState controllerState = new ControllerState();
        for (UnitConfiguration unitConfiguration : unitConfigurations) {
            this.processGenerationUnit(controllerState, unitConfiguration);
        }
        controllerState.getVariableStore().endGeneration();
    }

    protected void initLogging() {
        InputStream log4jStream = Controller.class.getClassLoader().getResourceAsStream("org/apache/torque/generator/log4j.properties");
        Properties log4jProperties = new Properties();
        try {
            log4jProperties.load(log4jStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        PropertyConfigurator.configure((Properties)log4jProperties);
    }

    private Configuration readConfiguration(List<UnitDescriptor> unitDescriptors) throws ConfigurationException {
        log.info((Object)"readConfiguration() : Starting to read configuration files");
        Configuration configuration = new Configuration();
        configuration.addUnits(unitDescriptors);
        configuration.read();
        log.info((Object)"readConfiguration() : Configuration read.");
        return configuration;
    }

    protected void processGenerationUnit(ControllerState controllerState, UnitConfiguration unitConfiguration) throws GeneratorException {
        log.debug((Object)"processGenerationUnit() : start");
        unitConfiguration.getLoglevel().apply();
        log.debug((Object)"processGenerationUnit() : Loglevel applied.");
        controllerState.setUnitConfiguration(unitConfiguration);
        List<Output> outputList = unitConfiguration.getOutputList();
        for (Output output : outputList) {
            this.processOutput(output, controllerState, unitConfiguration);
        }
    }

    private void processOutput(Output output, ControllerState controllerState, UnitConfiguration unitConfiguration) throws GeneratorException {
        log.info((Object)("Processing output " + output.getName()));
        controllerState.setOutput(output);
        SourceProvider sourceProvider = output.getSourceProvider();
        SourceProvider overrideSourceProvider = unitConfiguration.getOverrideSourceProvider();
        if (overrideSourceProvider != null) {
            overrideSourceProvider = overrideSourceProvider.copy();
            overrideSourceProvider.copyNotSetSettingsFrom(sourceProvider);
            sourceProvider = overrideSourceProvider;
        }
        controllerState.setSourceProvider(sourceProvider);
        sourceProvider.init(unitConfiguration.getConfigurationHandlers(), controllerState);
        if (!sourceProvider.hasNext()) {
            log.info((Object)"No sources found, skipping output");
        }
        while (sourceProvider.hasNext()) {
            Source source = (Source)sourceProvider.next();
            this.processSourceInOutput(source, output, controllerState, unitConfiguration);
        }
        controllerState.setSourceProvider(null);
    }

    private void processSourceInOutput(Source source, Output output, ControllerState controllerState, UnitConfiguration unitConfiguration) throws GeneratorException {
        log.info((Object)("Processing source " + source.getDescription()));
        SourceElement rootElement = source.getRootElement();
        controllerState.setSourceFile(source.getSourceFile());
        SourceProcessConfiguration sourceProcessConfiguration = output.getSourceProcessConfiguration();
        rootElement = this.transformSource(rootElement, sourceProcessConfiguration.getTransformerDefinitions(), controllerState);
        controllerState.setRootElement(rootElement);
        String startElementsPath = sourceProcessConfiguration.getStartElementsPath();
        List<SourceElement> startElements = SourcePath.getElementsFromRoot(rootElement, startElementsPath);
        if (startElements.isEmpty()) {
            log.info((Object)("No start Elements found for path " + startElementsPath));
        }
        for (SourceElement startElement : startElements) {
            this.processStartElement(startElement, output, source, unitConfiguration, controllerState);
        }
    }

    protected void createOutputFilename(Output output, ControllerState controllerState) throws GeneratorException {
        if (output.getFilenameOutlet() == null) {
            if (output.getFilename() == null) {
                throw new ConfigurationException("neither filename nor filenameOutlet are set on output" + output);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Start generation of Output File path");
            }
            controllerState.setOutputFile(null);
            Outlet filenameOutlet = output.getFilenameOutlet();
            OutletReference contentOutletReference = new OutletReference(filenameOutlet.getName());
            controllerState.setRootOutletReference(contentOutletReference);
            controllerState.setOutletNamespace(output.getContentOutlet().getNamespace());
            filenameOutlet.beforeExecute(controllerState);
            OutletResult filenameResult = filenameOutlet.execute(controllerState);
            if (!filenameResult.isStringResult()) {
                throw new GeneratorException("The result of a filename generation must be a String, not a byte array");
            }
            String filename = filenameResult.getStringResult();
            filenameOutlet.afterExecute(controllerState);
            if (log.isDebugEnabled()) {
                log.debug((Object)("End generation of Output File path, result is " + filename));
            }
            output.setFilename(filename);
        }
    }

    private void processStartElement(SourceElement startElement, Output output, Source source, UnitConfiguration unitConfiguration, ControllerState controllerState) throws GeneratorException {
        boolean success;
        File parentOutputDir;
        if (startElement == null) {
            throw new ControllerException("Null start element found in source for generating the filename of output file " + output);
        }
        controllerState.setSourceElement(startElement);
        log.debug((Object)("Processing new startElement " + startElement.getName()));
        ExistingTargetStrategy existingTargetStrategy = null;
        for (ExistingTargetStrategy candidate : EXISTING_TARGET_STRATEGIES) {
            if (!candidate.getStrategyName().equals(output.getExistingTargetStrategy())) continue;
            existingTargetStrategy = candidate;
            break;
        }
        if (existingTargetStrategy == null) {
            throw new ControllerException("existingTargetStrategy " + output.getExistingTargetStrategy() + " not found");
        }
        this.createOutputFilename(output, controllerState);
        File outputFile = ControllerHelper.getOutputFile(output.getOutputDirKey(), output.getFilename(), unitConfiguration);
        controllerState.setOutputFile(outputFile);
        if (!existingTargetStrategy.beforeGeneration(output.getOutputDirKey(), output.getFilename(), this.getOutputEncoding(output, unitConfiguration), unitConfiguration)) {
            log.info((Object)("Skipping generation of File " + outputFile.getAbsolutePath() + " because of existingTargetStrategy " + existingTargetStrategy.getStrategyName()));
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Start generation of File " + outputFile.getAbsolutePath()));
        }
        OutletReference contentOutletConfiguration = output.getContentOutlet();
        controllerState.setOutletNamespace(contentOutletConfiguration.getNamespace());
        controllerState.setRootOutletReference(contentOutletConfiguration);
        OutletConfiguration outletConfiguration = unitConfiguration.getOutletConfiguration();
        Outlet outlet = outletConfiguration.getOutlet(contentOutletConfiguration.getName());
        if (outlet == null) {
            throw new ControllerException("No outlet configured for outlet name \"" + contentOutletConfiguration.getName() + "\"");
        }
        SkipDecider skipDecider = output.getSourceProcessConfiguration().getSkipDecider();
        if (skipDecider != null) {
            if (!skipDecider.proceed(controllerState)) {
                log.debug((Object)("SkipDecider " + skipDecider.getClass().getName() + " decided to skip " + "generation of file " + controllerState.getOutputFile()));
                return;
            }
            log.debug((Object)("SkipDecider " + skipDecider.getClass().getName() + " decided to proceed"));
        }
        if ((parentOutputDir = controllerState.getOutputFile().getParentFile()) != null && !parentOutputDir.isDirectory() && !(success = parentOutputDir.mkdirs())) {
            throw new ControllerException("Could not create directory \"" + parentOutputDir.getAbsolutePath() + "\"");
        }
        outlet.beforeExecute(controllerState);
        OutletResult result = outlet.execute(controllerState);
        outlet.afterExecute(controllerState);
        existingTargetStrategy.afterGeneration(output.getOutputDirKey(), output.getFilename(), this.getOutputEncoding(output, unitConfiguration), result, unitConfiguration);
        controllerState.getVariableStore().endFile();
        if (log.isDebugEnabled()) {
            log.debug((Object)("End generation of Output File " + controllerState.getOutputFile()));
        }
    }

    public SourceElement transformSource(SourceElement rootElement, List<SourceTransformerDefinition> transformerDefinitions, ControllerState controllerState) throws SourceTransformerException, SourceException {
        SourceElement result = rootElement;
        for (SourceTransformerDefinition transformerDefinition : transformerDefinitions) {
            SourceTransformer sourceTransformer = transformerDefinition.getSourceTransformer();
            String elements = transformerDefinition.getElements();
            log.debug((Object)("Applying source transformer " + sourceTransformer.getClass().getName() + (elements == null ? " to the root element" : " to the elements " + elements)));
            List<SourceElement> toTransform = SourcePath.getElementsFromRoot(rootElement, elements);
            if (toTransform.isEmpty()) {
                log.debug((Object)"No element found, nothing transformed");
            }
            for (SourceElement sourceElement : toTransform) {
                log.debug((Object)("transforming element " + sourceElement));
                SourceElement transformedElement = sourceTransformer.transform(sourceElement, controllerState);
                if (transformedElement == null) {
                    throw new SourceTransformerException("Transformer " + sourceTransformer.getClass().getName() + " returned null for element " + sourceElement.getName());
                }
                SourceElement parent = sourceElement.getParent();
                if (parent == null) {
                    result = transformedElement;
                    continue;
                }
                List<SourceElement> children = parent.getChildren();
                int index = children.indexOf(sourceElement);
                children.set(index, transformedElement);
            }
            log.debug((Object)"Transformation ended");
        }
        return result;
    }

    private String getOutputEncoding(Output output, UnitConfiguration unitConfiguration) {
        if (output.getEncoding() != null) {
            return output.getEncoding();
        }
        if (unitConfiguration.getDefaultOutputEncoding() != null) {
            return unitConfiguration.getDefaultOutputEncoding();
        }
        return Charset.defaultCharset().displayName();
    }

    static {
        ArrayList<ExistingTargetStrategy> existingTargetStrategies = new ArrayList<ExistingTargetStrategy>();
        existingTargetStrategies.add(new ReplaceTargetFileStrategy());
        existingTargetStrategies.add(new SkipExistingTargetFileStrategy());
        existingTargetStrategies.add(new MergeTargetFileStrategy());
        existingTargetStrategies.add(new AppendToTargetFileStrategy());
        EXISTING_TARGET_STRATEGIES = Collections.unmodifiableList(existingTargetStrategies);
    }
}

