/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.AbstractConfigurationProvider;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.paths.ProjectPaths;
import org.apache.torque.generator.configuration.paths.TorqueGeneratorPaths;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarConfigurationProvider
extends AbstractConfigurationProvider {
    private static Log log = LogFactory.getLog(JarConfigurationProvider.class);
    private ProjectPaths projectPaths;
    private TorqueGeneratorPaths configurationPaths;
    private JarFile jarFile;

    public JarConfigurationProvider(ProjectPaths projectPaths, TorqueGeneratorPaths configurationPaths) throws ConfigurationException {
        super(configurationPaths);
        if (projectPaths == null) {
            throw new NullPointerException("projectPaths is null");
        }
        this.projectPaths = projectPaths;
        this.configurationPaths = configurationPaths;
        try {
            this.jarFile = new JarFile(projectPaths.getConfigurationPath());
        }
        catch (IOException e) {
            log.error((Object)("Could not open jar File " + projectPaths.getConfigurationPath().getAbsolutePath()));
            throw new ConfigurationException(e);
        }
    }

    @Override
    public String getControlConfigurationLocation() throws ConfigurationException {
        return this.projectPaths.getConfigurationPath() + ":" + this.configurationPaths.getConfigurationDirectory() + "/" + this.configurationPaths.getControlConfigurationFile();
    }

    @Override
    protected InputStream getInputStream(String name, String directory, String description) throws ConfigurationException {
        String fileName = directory + "/" + name;
        InputStream inputStream = null;
        try {
            JarEntry jarEntry = this.jarFile.getJarEntry(fileName);
            inputStream = this.jarFile.getInputStream(jarEntry);
        }
        catch (IOException e) {
            throw new ConfigurationException("Could not read " + description + " file " + fileName + " in jar file " + this.projectPaths.getConfigurationPath(), e);
        }
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading " + description + " file: '" + this.projectPaths.getConfigurationPath() + "' in jar file " + this.projectPaths.getConfigurationPath()));
        }
        return bis;
    }

    @Override
    public Collection<String> getOutletConfigurationNames() throws ConfigurationException {
        return JarConfigurationProvider.getOutletConfigurationNames(this.jarFile, this.configurationPaths.getOutletDirectory());
    }

    static Collection<String> getOutletConfigurationNames(JarFile jarFile, String outletConfigurationDirectory) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Analyzing jar file " + jarFile.getName() + " seeking Directory " + outletConfigurationDirectory));
        }
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String rawName;
            JarEntry jarEntry = entries.nextElement();
            if (jarEntry.isDirectory() || !(rawName = jarEntry.getName()).startsWith(outletConfigurationDirectory)) continue;
            String name = rawName.substring(rawName.lastIndexOf(47) + 1);
            int expectedRawNameLength = outletConfigurationDirectory.length() + name.length() + 1;
            if (rawName.length() != expectedRawNameLength) continue;
            result.add(name);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found the following outlet configuration files " + result));
        }
        return result;
    }
}

