/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.controller;

import java.io.IOException;
import org.apache.torque.generator.configuration.ConfigurationEntityResolver;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.SaxHelper;
import org.apache.torque.generator.configuration.controller.ControlConfiguration;
import org.apache.torque.generator.configuration.controller.Loglevel;
import org.apache.torque.generator.configuration.controller.Output;
import org.apache.torque.generator.configuration.controller.OutputSaxHandler;
import org.apache.torque.generator.configuration.mergepoint.OptionsSaxHandlerFactories;
import org.apache.torque.generator.configuration.option.OptionsConfiguration;
import org.apache.torque.generator.configuration.option.OptionsSaxHandler;
import org.apache.torque.generator.configuration.option.OptionsSaxHandlerFactory;
import org.apache.torque.generator.configuration.paths.ProjectPaths;
import org.apache.torque.generator.configuration.source.EntityReferenceSaxHandler;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ControlConfigurationSaxHandler
extends DefaultHandler {
    private ControlConfiguration controllerConfiguration;
    private ConfigurationHandlers configurationHandlers;
    private OutputSaxHandler outputSaxHandler;
    private EntityReferenceSaxHandler entityReferenceSaxHandler;
    private OptionsSaxHandler optionsSaxHandler;
    private ConfigurationProvider configurationProvider;
    private ProjectPaths projectPaths;

    public ControlConfigurationSaxHandler(ControlConfiguration controllerConfiguration, ConfigurationProvider configurationProvider, ProjectPaths projectPaths, ConfigurationHandlers configurationHandlers) {
        if (controllerConfiguration == null) {
            throw new NullPointerException("controllerConfiguration must not be null");
        }
        if (configurationProvider == null) {
            throw new NullPointerException("configurationProvider must not be null");
        }
        if (projectPaths == null) {
            throw new NullPointerException("projectPaths must not be null");
        }
        if (configurationHandlers == null) {
            throw new NullPointerException("configurationHandlers must not be null");
        }
        this.configurationProvider = configurationProvider;
        this.controllerConfiguration = controllerConfiguration;
        this.configurationHandlers = configurationHandlers;
        this.projectPaths = projectPaths;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String unqualifiedName = SaxHelper.getUnqualifiedName(localName, qName);
        if (this.outputSaxHandler != null) {
            this.outputSaxHandler.startElement(uri, localName, qName, attributes);
        } else if (this.optionsSaxHandler != null) {
            this.optionsSaxHandler.startElement(uri, localName, qName, attributes);
        } else if (this.entityReferenceSaxHandler != null) {
            this.entityReferenceSaxHandler.startElement(uri, localName, qName, attributes);
        } else if ("control".equals(unqualifiedName)) {
            String loglevel = attributes.getValue("loglevel");
            if (loglevel != null) {
                Loglevel level = Loglevel.getByKey(loglevel);
                this.controllerConfiguration.setLoglevel(level);
            }
        } else if ("options".equals(unqualifiedName)) {
            String type = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (type == null) {
                throw new SAXException("The tag options requires the attribute http://www.w3.org/2001/XMLSchema-instance:type");
            }
            OptionsSaxHandlerFactories optionsSaxHandlerFactories = this.configurationHandlers.getOptionsSaxHandlerFactories();
            OptionsSaxHandlerFactory optionsSaxHandlerFactory = optionsSaxHandlerFactories.getOptionsSaxHandlerFactory(type);
            if (optionsSaxHandlerFactory == null) {
                throw new SAXException("No handler found for the action of type " + type);
            }
            this.optionsSaxHandler = optionsSaxHandlerFactory.getOptionsSaxHandler();
            this.optionsSaxHandler.startElement(uri, localName, qName, attributes);
        } else if ("output".equals(unqualifiedName)) {
            this.outputSaxHandler = new OutputSaxHandler(this.configurationProvider, this.projectPaths, this.configurationHandlers);
            this.outputSaxHandler.startElement(uri, localName, qName, attributes);
        } else if ("entityReference".equals(unqualifiedName)) {
            this.entityReferenceSaxHandler = new EntityReferenceSaxHandler(this.configurationProvider, this.projectPaths);
            this.entityReferenceSaxHandler.startElement(uri, localName, qName, attributes);
        } else {
            throw new SAXException("Unknown element " + unqualifiedName);
        }
    }

    public void endElement(String uri, String localName, String rawName) throws SAXException {
        if (this.optionsSaxHandler != null) {
            this.optionsSaxHandler.endElement(uri, localName, rawName);
            if (this.optionsSaxHandler.isFinished()) {
                OptionsConfiguration optionsConfiguration = this.optionsSaxHandler.getOptionsConfiguration();
                this.controllerConfiguration.addOptionsConfiguration(optionsConfiguration);
                this.optionsSaxHandler = null;
            }
        } else if ("output".equals(rawName)) {
            this.outputSaxHandler.endElement(uri, localName, rawName);
            Output outputFile = this.outputSaxHandler.getOutputFile();
            try {
                this.controllerConfiguration.addOutput(outputFile);
            }
            catch (ConfigurationException e) {
                throw new SAXException("Could not add output " + outputFile.getName(), e);
            }
            this.outputSaxHandler = null;
        } else if (this.outputSaxHandler != null) {
            this.outputSaxHandler.endElement(uri, localName, rawName);
        } else if (this.entityReferenceSaxHandler != null) {
            this.entityReferenceSaxHandler.endElement(uri, localName, rawName);
            if (this.entityReferenceSaxHandler.isFinished()) {
                try {
                    this.controllerConfiguration.getEntityReferences().addEntityReference(this.entityReferenceSaxHandler.getSystemId(), this.entityReferenceSaxHandler.readResource());
                }
                catch (ConfigurationException e) {
                    throw new SAXException("Could not read entity reference " + this.entityReferenceSaxHandler.getSystemId(), e);
                }
                this.entityReferenceSaxHandler = null;
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.outputSaxHandler != null) {
            this.outputSaxHandler.characters(ch, start, length);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return new ConfigurationEntityResolver().resolveEntity(publicId, systemId);
    }

    public void error(SAXParseException exception) throws SAXParseException {
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXParseException {
        throw exception;
    }

    public void warning(SAXParseException exception) throws SAXParseException {
        throw exception;
    }
}

