/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source.transform.model;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.torque.generator.source.transform.SourceTransformerException;
import org.apache.torque.generator.source.transform.model.NoSuchPropertyException;
import org.apache.torque.generator.source.transform.model.PropertyNotReadableException;
import org.apache.torque.generator.source.transform.model.PropertyNotWriteableException;
import org.apache.torque.generator.source.transform.model.StringToBooleanConverter;
import org.apache.torque.generator.source.transform.model.TypeConverter;

public class PropertyAccess {
    private static List<TypeConverter> converters = new ArrayList<TypeConverter>();
    private final Object target;
    private final String propertyName;
    private List<String> prefixList;
    private List<String> suffixList;
    private Field field;
    private Method writeMethod;
    private Method readMethod;

    public PropertyAccess(Object target, String propertyName) throws SourceTransformerException {
        this(target, propertyName, Arrays.asList("_"), Arrays.asList("s", "Array", "List"));
    }

    public PropertyAccess(Object target, String propertyName, List<String> prefixList, List<String> suffixList) throws SourceTransformerException {
        if (target == null) {
            throw new NullPointerException("target must not be null");
        }
        if (propertyName == null) {
            throw new NullPointerException("propertyName must not be null");
        }
        this.target = target;
        this.propertyName = propertyName;
        this.prefixList = prefixList != null ? new ArrayList<String>(prefixList) : new ArrayList<String>();
        this.suffixList = suffixList != null ? new ArrayList<String>(suffixList) : new ArrayList<String>();
        this.suffixList.add(0, "");
        for (String suffix : this.suffixList) {
            this.field = PropertyAccess.determinePublicField(target, propertyName + suffix);
            if (this.field == null) continue;
            break;
        }
        if (this.field == null) {
            for (String prefix : this.prefixList) {
                this.field = PropertyAccess.determinePublicField(target, prefix + propertyName);
                if (this.field == null) continue;
                break;
            }
        }
        if (this.field == null) {
            PropertyDescriptor propertyDescriptor = null;
            for (String suffix : this.suffixList) {
                propertyDescriptor = PropertyAccess.determinePropertyDescriptor(target, propertyName + suffix);
                if (propertyDescriptor == null) continue;
                break;
            }
            if (propertyDescriptor != null) {
                this.readMethod = propertyDescriptor.getReadMethod();
                this.writeMethod = propertyDescriptor.getWriteMethod();
            }
        }
    }

    private static Field determinePublicField(Object target, String name) throws SourceTransformerException {
        try {
            Field fieldCandidate = target.getClass().getField(name);
            if (Modifier.isPublic(fieldCandidate.getModifiers())) {
                return fieldCandidate;
            }
        }
        catch (SecurityException e) {
            throw PropertyAccess.createSetFieldException(target, name, null, " because access is denied to the field or package", e);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    private static PropertyDescriptor determinePropertyDescriptor(Object target, String name) throws SourceTransformerException {
        try {
            PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor((Object)target, (String)name);
            return propertyDescriptor;
        }
        catch (NoSuchMethodException e) {
            throw new SourceTransformerException(e);
        }
        catch (IllegalAccessException e) {
            throw new SourceTransformerException(e);
        }
        catch (InvocationTargetException e) {
            throw new SourceTransformerException(e);
        }
    }

    public void setProperty(Object value) throws SourceTransformerException {
        if (this.field != null) {
            if (this.field.getType().isArray() && (value == null || !value.getClass().isArray())) {
                this.setMemberinArrayField(value);
            } else if (Collection.class.isAssignableFrom(this.field.getType()) && (value == null || !Collection.class.isAssignableFrom(value.getClass()))) {
                this.setMemberinCollectionProperty(value);
            } else {
                this.setPropertyStrictUsingField(value);
            }
            return;
        }
        if (this.writeMethod != null) {
            if (this.writeMethod.getParameterTypes()[0].isArray() && (value == null || !value.getClass().isArray())) {
                this.setMemberinArrayField(value);
            } else if (Collection.class.isAssignableFrom(this.writeMethod.getParameterTypes()[0]) && (value == null || !Collection.class.isAssignableFrom(value.getClass()))) {
                this.setMemberinCollectionProperty(value);
            } else {
                this.setPropertyStrictUsingSetter(value);
            }
            return;
        }
        if (this.readMethod != null) {
            if (Collection.class.isAssignableFrom(this.readMethod.getReturnType()) && (value == null || !Collection.class.isAssignableFrom(value.getClass()))) {
                this.setMemberinCollectionProperty(value);
                return;
            }
            throw new PropertyNotWriteableException(this.target, this.propertyName);
        }
        throw new NoSuchPropertyException(this.target, this.propertyName, this.prefixList, this.suffixList);
    }

    public void setPropertyStrict(Object value) throws SourceTransformerException {
        if (this.field != null) {
            this.setPropertyStrictUsingField(value);
            return;
        }
        if (this.writeMethod != null) {
            this.setPropertyStrictUsingSetter(value);
            return;
        }
        if (this.readMethod != null) {
            throw new PropertyNotWriteableException(this.target, this.propertyName);
        }
        throw new NoSuchPropertyException(this.target, this.propertyName, this.prefixList, this.suffixList);
    }

    private void setPropertyStrictUsingField(Object value) throws SourceTransformerException {
        for (TypeConverter converter : converters) {
            if (!converter.accept(value, this.field.getType())) continue;
            value = converter.convert(value, this.field.getType());
            break;
        }
        try {
            this.field.set(this.target, value);
        }
        catch (IllegalArgumentException e) {
            if (value == null) {
                throw this.createSetFieldException(null, " because the value is null which is not allowed", e);
            }
            throw this.createSetFieldException(value, " because the argument has the wrong type " + value.getClass().getName(), e);
        }
        catch (IllegalAccessException e) {
            throw this.createSetFieldException(null, " because the field cannot be accessed", e);
        }
    }

    private void setPropertyStrictUsingSetter(Object value) throws SourceTransformerException {
        for (TypeConverter converter : converters) {
            if (!converter.accept(value, this.writeMethod.getParameterTypes()[0])) continue;
            value = converter.convert(value, this.writeMethod.getParameterTypes()[0]);
            break;
        }
        try {
            this.writeMethod.invoke(this.target, value);
            return;
        }
        catch (IllegalArgumentException e) {
            if (value == null) {
                throw this.createSetFieldException(null, " because the value is null which is not allowed", e);
            }
            throw this.createSetFieldException(value, " because the argument has the wrong type " + value.getClass().getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new SourceTransformerException(e);
        }
        catch (InvocationTargetException e) {
            throw new SourceTransformerException(e);
        }
    }

    public Object getProperty() throws SourceTransformerException {
        if (this.field != null) {
            return this.getPropertyUsingField();
        }
        if (this.readMethod != null) {
            return this.getPropertyUsingGetter();
        }
        throw new PropertyNotReadableException(this.target, this.propertyName);
    }

    private Object getPropertyUsingField() throws SourceTransformerException {
        try {
            return this.field.get(this.target);
        }
        catch (IllegalArgumentException e) {
            throw new SourceTransformerException(e);
        }
        catch (IllegalAccessException e) {
            throw new SourceTransformerException(e);
        }
    }

    private Object getPropertyUsingGetter() throws SourceTransformerException {
        try {
            return this.readMethod.invoke(this.target, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new SourceTransformerException(e);
        }
        catch (IllegalAccessException e) {
            throw new SourceTransformerException(e);
        }
        catch (InvocationTargetException e) {
            throw new SourceTransformerException(e);
        }
    }

    public boolean isPropertyAccessible() {
        return this.field != null || this.readMethod != null || this.writeMethod != null;
    }

    public Class<?> getPropertyType() {
        if (this.field != null) {
            return this.field.getType();
        }
        if (this.writeMethod != null) {
            return this.writeMethod.getParameterTypes()[0];
        }
        if (this.readMethod != null) {
            return this.readMethod.getReturnType();
        }
        return null;
    }

    public Type getPropertyGenericType() {
        if (this.field != null) {
            return this.field.getGenericType();
        }
        if (this.writeMethod != null) {
            return this.writeMethod.getGenericParameterTypes()[0];
        }
        if (this.readMethod != null) {
            return this.readMethod.getGenericReturnType();
        }
        return null;
    }

    public Class<?> getFirstGenericTypeArgument() {
        Type firstType;
        Type type = this.getPropertyGenericType();
        if (type instanceof ParameterizedType && (firstType = ((ParameterizedType)type).getActualTypeArguments()[0]) instanceof Class) {
            return (Class)firstType;
        }
        return null;
    }

    public List<String> getPrefixList() {
        return Collections.unmodifiableList(this.prefixList);
    }

    public List<String> getSuffixList() {
        return Collections.unmodifiableList(this.suffixList);
    }

    private void setMemberinArrayField(Object value) throws SourceTransformerException {
        int newIndex;
        Object newContent;
        Object[] oldContent = (Object[])this.getProperty();
        if (oldContent == null) {
            newContent = Array.newInstance(this.getPropertyType().getComponentType(), 1);
            newIndex = 0;
        } else {
            newContent = Array.newInstance(this.getPropertyType().getComponentType(), oldContent.length + 1);
            System.arraycopy(oldContent, 0, newContent, 0, oldContent.length);
            newIndex = oldContent.length;
        }
        ((Object[])newContent)[newIndex] = value;
        this.setPropertyStrict(newContent);
    }

    private void setMemberinCollectionProperty(Object value) throws SourceTransformerException {
        Collection<Object> content = (Collection<Object>)this.getProperty();
        if (content == null) {
            content = this.getCollectionInstance();
            this.setPropertyStrict(content);
        }
        content.add(value);
    }

    private Collection<Object> getCollectionInstance() throws SourceTransformerException {
        Class<?> type = this.getPropertyType();
        if (Collection.class == type || List.class == type) {
            return new ArrayList<Object>();
        }
        if (Set.class == type) {
            return new HashSet<Object>();
        }
        if (Queue.class == type) {
            return new LinkedList<Object>();
        }
        try {
            Collection result = (Collection)type.newInstance();
            return result;
        }
        catch (InstantiationException e) {
            throw new SourceTransformerException(e);
        }
        catch (IllegalAccessException e) {
            throw new SourceTransformerException(e);
        }
    }

    private SourceTransformerException createSetFieldException(Object value, String reason, Throwable cause) {
        return PropertyAccess.createSetFieldException(this.target, this.propertyName, value, reason, cause);
    }

    private static SourceTransformerException createSetFieldException(Object target, String propertyName, Object value, String reason, Throwable cause) {
        StringBuilder message = new StringBuilder("The field ").append(propertyName).append(" of class ").append(target.getClass().getName());
        if (value != null) {
            message.append(" cannot be set to ").append(value);
        }
        message.append(reason);
        return new SourceTransformerException(message.toString(), cause);
    }

    static {
        converters.add(new StringToBooleanConverter());
    }
}

