/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.internal.storage.dfs.BlockBasedFile;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.pack.PackExt;

public interface DfsBlockCacheTable {
    public boolean hasBlock0(DfsStreamKey var1);

    public DfsBlock getOrLoad(BlockBasedFile var1, long var2, DfsReader var4, DfsBlockCache.ReadableChannelSupplier var5) throws IOException;

    public <T> DfsBlockCache.Ref<T> getOrLoadRef(DfsStreamKey var1, long var2, DfsBlockCache.RefLoader<T> var4) throws IOException;

    public void put(DfsBlock var1);

    public <T> DfsBlockCache.Ref<T> put(DfsStreamKey var1, long var2, long var4, T var6);

    public <T> DfsBlockCache.Ref<T> putRef(DfsStreamKey var1, long var2, T var4);

    public boolean contains(DfsStreamKey var1, long var2);

    public <T> T get(DfsStreamKey var1, long var2);

    public DfsBlockCacheStats getDfsBlockCacheStats();

    public static class DfsBlockCacheStats {
        private final AtomicReference<AtomicLong[]> statHit = new AtomicReference<AtomicLong[]>(DfsBlockCacheStats.newCounters());
        private final AtomicReference<AtomicLong[]> statMiss = new AtomicReference<AtomicLong[]>(DfsBlockCacheStats.newCounters());
        private final AtomicReference<AtomicLong[]> statEvict = new AtomicReference<AtomicLong[]>(DfsBlockCacheStats.newCounters());
        private final AtomicReference<AtomicLong[]> liveBytes = new AtomicReference<AtomicLong[]>(DfsBlockCacheStats.newCounters());

        DfsBlockCacheStats() {
        }

        void incrementHit(DfsStreamKey key) {
            DfsBlockCacheStats.getStat(this.statHit, key).incrementAndGet();
        }

        void incrementMiss(DfsStreamKey key) {
            DfsBlockCacheStats.getStat(this.statMiss, key).incrementAndGet();
        }

        void incrementEvict(DfsStreamKey key) {
            DfsBlockCacheStats.getStat(this.statEvict, key).incrementAndGet();
        }

        void addToLiveBytes(DfsStreamKey key, long size) {
            DfsBlockCacheStats.getStat(this.liveBytes, key).addAndGet(size);
        }

        long[] getCurrentSize() {
            return DfsBlockCacheStats.getStatVals(this.liveBytes);
        }

        long[] getHitCount() {
            return DfsBlockCacheStats.getStatVals(this.statHit);
        }

        long[] getMissCount() {
            return DfsBlockCacheStats.getStatVals(this.statMiss);
        }

        long[] getTotalRequestCount() {
            AtomicLong[] hit = this.statHit.get();
            AtomicLong[] miss = this.statMiss.get();
            long[] cnt = new long[Math.max(hit.length, miss.length)];
            int i = 0;
            while (i < hit.length) {
                int n = i;
                cnt[n] = cnt[n] + hit[i].get();
                ++i;
            }
            i = 0;
            while (i < miss.length) {
                int n = i;
                cnt[n] = cnt[n] + miss[i].get();
                ++i;
            }
            return cnt;
        }

        long[] getHitRatio() {
            AtomicLong[] hit = this.statHit.get();
            AtomicLong[] miss = this.statMiss.get();
            long[] ratio = new long[Math.max(hit.length, miss.length)];
            int i = 0;
            while (i < ratio.length) {
                long missVal;
                long hitVal;
                long total;
                ratio[i] = i >= hit.length ? 0L : (i >= miss.length ? 100L : ((total = (hitVal = hit[i].get()) + (missVal = miss[i].get())) == 0L ? 0L : hitVal * 100L / total));
                ++i;
            }
            return ratio;
        }

        long[] getEvictions() {
            return DfsBlockCacheStats.getStatVals(this.statEvict);
        }

        private static AtomicLong[] newCounters() {
            AtomicLong[] ret = new AtomicLong[PackExt.values().length];
            int i = 0;
            while (i < ret.length) {
                ret[i] = new AtomicLong();
                ++i;
            }
            return ret;
        }

        private static long[] getStatVals(AtomicReference<AtomicLong[]> stat) {
            AtomicLong[] stats = stat.get();
            long[] cnt = new long[stats.length];
            int i = 0;
            while (i < stats.length) {
                cnt[i] = stats[i].get();
                ++i;
            }
            return cnt;
        }

        private static AtomicLong getStat(AtomicReference<AtomicLong[]> stats, DfsStreamKey key) {
            AtomicLong[] vals;
            AtomicLong[] expect;
            int pos = key.packExtPos;
            do {
                if (pos < (vals = stats.get()).length) {
                    return vals[pos];
                }
                expect = vals;
                vals = new AtomicLong[Math.max(pos + 1, PackExt.values().length)];
                System.arraycopy(expect, 0, vals, 0, expect.length);
                int i = expect.length;
                while (i < vals.length) {
                    vals[i] = new AtomicLong();
                    ++i;
                }
            } while (!stats.compareAndSet(expect, vals));
            return vals[pos];
        }
    }
}

