/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.config;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.deltaspike.core.api.config.ConfigProperty;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.spi.config.BaseConfigPropertyProducer;

@ApplicationScoped
public class DefaultConfigPropertyProducer
extends BaseConfigPropertyProducer {
    @Produces
    @Dependent
    @ConfigProperty(name="ignored")
    public String produceStringConfiguration(InjectionPoint injectionPoint) {
        return this.getStringPropertyValue(injectionPoint);
    }

    @Produces
    @Dependent
    @ConfigProperty(name="ignored")
    public Class produceClassConfiguration(InjectionPoint injectionPoint) {
        return (Class)this.getPropertyWithException(injectionPoint, (Type)((Object)Class.class));
    }

    @Produces
    @Dependent
    @ConfigProperty(name="ignored")
    public Boolean produceBooleanConfiguration(InjectionPoint injectionPoint) {
        return (Boolean)this.getPropertyWithException(injectionPoint, (Type)((Object)Boolean.class));
    }

    @Produces
    @Dependent
    @ConfigProperty(name="ignored")
    public Integer produceIntegerConfiguration(InjectionPoint injectionPoint) {
        return (Integer)this.getPropertyWithException(injectionPoint, (Type)((Object)Integer.class));
    }

    @Produces
    @Dependent
    @ConfigProperty(name="ignored")
    public Long produceLongConfiguration(InjectionPoint injectionPoint) {
        return (Long)this.getPropertyWithException(injectionPoint, (Type)((Object)Long.class));
    }

    @Produces
    @Dependent
    @ConfigProperty(name="ignored")
    public Float produceFloatConfiguration(InjectionPoint injectionPoint) {
        return (Float)this.getPropertyWithException(injectionPoint, (Type)((Object)Float.class));
    }

    @Produces
    @Dependent
    @ConfigProperty(name="ignored")
    public Double produceDoubleConfiguration(InjectionPoint injectionPoint) {
        return (Double)this.getPropertyWithException(injectionPoint, (Type)((Object)Double.class));
    }

    @Produces
    @Dependent
    @ConfigProperty(name="ignore")
    public <C> Supplier<C> produceConfigSupplier(InjectionPoint injectionPoint) {
        ConfigProperty configProperty = (ConfigProperty)this.getAnnotation(injectionPoint, ConfigProperty.class);
        if (configProperty == null) {
            throw new IllegalStateException("producer method called without @ConfigProperty being present!");
        }
        Type injectionPointType = injectionPoint.getType();
        Type ipClass = null;
        if (!(injectionPointType instanceof ParameterizedType) || ((ParameterizedType)injectionPointType).getActualTypeArguments().length != 1) {
            throw new IllegalStateException("Supplier for Configuration must be a Parameterized Type");
        }
        ipClass = ((ParameterizedType)injectionPointType).getActualTypeArguments()[0];
        ConfigResolver.TypedResolver resolver = this.asResolver(configProperty.name(), configProperty.defaultValue(), ipClass, configProperty.converter(), configProperty.parameterizedBy(), configProperty.projectStageAware(), configProperty.evaluateVariables());
        if (configProperty.cacheFor() > 0L) {
            resolver.cacheFor(configProperty.cacheUnit(), configProperty.cacheFor());
        }
        return () -> resolver.getValue();
    }

    private <T> T getPropertyWithException(InjectionPoint ip, Type ipCls) {
        try {
            return (T)this.getUntypedPropertyValue(ip, ipCls);
        }
        catch (RuntimeException rte) {
            ConfigProperty configProperty = (ConfigProperty)this.getAnnotation(ip, ConfigProperty.class);
            throw new RuntimeException("Error while converting property '" + configProperty.name() + "' happening in bean " + ip.getBean(), rte);
        }
    }
}

