/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.clientwindow;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.deltaspike.jsf.impl.clientwindow.DeltaSpikeClientWindow;
import org.apache.deltaspike.jsf.impl.util.ClientWindowHelper;
import org.apache.deltaspike.jsf.impl.util.JsfUtils;
import org.owasp.encoder.Encode;

public class ClientSideClientWindow
extends DeltaSpikeClientWindow {
    private static final String AUTOMATED_ENTRY_POINT_PARAMETER_KEY = "automatedEntryPoint";
    private static final String UNINITIALIZED_WINDOW_ID_VALUE = "uninitializedWindowId";
    private static final String WINDOW_ID_REPLACE_PATTERN = "$$windowIdValue$$";
    private static final String REQUEST_URL_REPLACE_PATTERN = "$$requestUrl$$";
    private static final String NOSCRIPT_URL_REPLACE_PATTERN = "$$noscriptUrl$$";
    private static final String NOSCRIPT_PARAMETER = "mfDirect";

    public void decode(FacesContext facesContext) {
        boolean post = this.isPost(facesContext);
        if (post) {
            this.id = this.getWindowIdPostParameter(facesContext);
        } else if (this.isNoscriptRequest(facesContext.getExternalContext())) {
            this.getClientWindowConfig().setJavaScriptEnabled(false);
            this.id = "default";
        } else {
            this.id = this.getVerifiedWindowIdFromCookie(facesContext.getExternalContext());
            boolean newWindowIdRequested = false;
            if (AUTOMATED_ENTRY_POINT_PARAMETER_KEY.equals(this.id)) {
                this.id = this.generateNewWindowId();
                newWindowIdRequested = true;
            }
            if (this.id == null || newWindowIdRequested) {
                this.sendWindowHandlerHtml(facesContext, facesContext.getExternalContext(), this.id);
                facesContext.responseComplete();
            }
        }
        this.id = this.sanitiseWindowId(this.id);
    }

    protected boolean isNoscriptRequest(ExternalContext externalContext) {
        String noscript = (String)externalContext.getRequestParameterMap().get(NOSCRIPT_PARAMETER);
        return noscript != null && "true".equals(noscript);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendWindowHandlerHtml(FacesContext facesContext, ExternalContext externalContext, String windowId) {
        HttpServletResponse httpResponse = (HttpServletResponse)externalContext.getResponse();
        try {
            httpResponse.setStatus(200);
            httpResponse.setContentType("text/html");
            String windowHandlerHtml = this.getClientWindowConfig().getClientWindowHtml();
            if (windowId == null) {
                windowId = UNINITIALIZED_WINDOW_ID_VALUE;
            }
            windowHandlerHtml = windowHandlerHtml.replace(WINDOW_ID_REPLACE_PATTERN, Encode.forJavaScriptBlock((String)windowId));
            windowHandlerHtml = windowHandlerHtml.replace(REQUEST_URL_REPLACE_PATTERN, Encode.forJavaScriptBlock((String)ClientWindowHelper.constructRequestUrl(facesContext, externalContext)));
            windowHandlerHtml = windowHandlerHtml.replace(NOSCRIPT_URL_REPLACE_PATTERN, Encode.forHtmlAttribute((String)this.getNoscriptUrl(externalContext)));
            try (ServletOutputStream os = httpResponse.getOutputStream();){
                os.write(windowHandlerHtml.getBytes());
            }
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
    }

    protected String getNoscriptUrl(ExternalContext externalContext) {
        int lastSlash;
        String url = externalContext.getRequestPathInfo();
        if (url == null) {
            url = "";
        }
        if ((lastSlash = url.lastIndexOf(47)) != -1) {
            url = url.substring(lastSlash + 1);
        }
        url = JsfUtils.addPageParameters(externalContext, url, true);
        url = JsfUtils.addParameter(externalContext, url, false, NOSCRIPT_PARAMETER, "true");
        url = url.replace("\"", "");
        url = url.replace("'", "");
        return url;
    }

    protected String getVerifiedWindowIdFromCookie(ExternalContext externalContext) {
        String cookieName = "dsrwid-" + this.getRequestTokenParameter(externalContext);
        Cookie cookie = (Cookie)externalContext.getRequestCookieMap().get(cookieName);
        if (cookie != null) {
            cookie.setMaxAge(0);
            return cookie.getValue();
        }
        return null;
    }

    protected String getRequestTokenParameter(ExternalContext externalContext) {
        String requestToken = (String)externalContext.getRequestParameterMap().get("dsrid");
        if (requestToken != null) {
            return requestToken;
        }
        return "";
    }

    @Override
    public String interceptRedirect(FacesContext facesContext, String url) {
        boolean get;
        boolean ajax = facesContext.getPartialViewContext().isAjaxRequest();
        boolean post = this.isPost(facesContext);
        boolean bl = get = !post;
        if (!ajax && get || ajax && post) {
            String requestToken = this.generateNewRequestToken();
            String windowId = this.getId();
            ClientWindowHelper.addRequestWindowIdCookie(facesContext, requestToken, windowId);
            url = JsfUtils.addParameter(facesContext.getExternalContext(), url, true, "dsrid", requestToken);
            return url;
        }
        return url;
    }

    @Override
    public boolean isInitialRedirectSupported(FacesContext facesContext) {
        return false;
    }

    public Map<String, String> getQueryURLParameters(FacesContext facesContext) {
        return Collections.emptyMap();
    }

    public boolean isClientWindowRenderModeEnabled(FacesContext facesContext) {
        return false;
    }
}

