/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.token;

import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PhaseListener;
import jakarta.inject.Inject;
import java.util.Map;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.jsf.api.listener.phase.JsfPhaseListener;
import org.apache.deltaspike.jsf.impl.token.PostRequestTokenManager;

@JsfPhaseListener(ordinal=9000)
public class DoubleSubmitAwarePhaseListener
implements PhaseListener,
Deactivatable {
    private static final long serialVersionUID = -4247051429332418226L;
    @Inject
    private PostRequestTokenManager postRequestTokenManager;

    public void afterPhase(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        if (facesContext.isPostback() && !facesContext.getPartialViewContext().isAjaxRequest()) {
            String receivedPostRequestToken = (String)facesContext.getExternalContext().getRequestParameterMap().get("dsprt");
            if (receivedPostRequestToken == null) {
                receivedPostRequestToken = this.findPostRequestTokenWithPrefix(facesContext);
            }
            if (!this.postRequestTokenManager.isValidRequest(receivedPostRequestToken)) {
                facesContext.renderResponse();
            }
        }
    }

    public void beforePhase(PhaseEvent event) {
        if (!event.getFacesContext().isPostback()) {
            this.postRequestTokenManager.createNewToken();
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    protected String findPostRequestTokenWithPrefix(FacesContext facesContext) {
        for (Map.Entry parameterEntry : facesContext.getExternalContext().getRequestParameterMap().entrySet()) {
            if (!((String)parameterEntry.getKey()).endsWith(":dsprt") && !((String)parameterEntry.getKey()).endsWith("_dsprt")) continue;
            return (String)parameterEntry.getValue();
        }
        return null;
    }
}

