/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.directory.api.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MethodUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MethodUtils.class);

    private MethodUtils() {
    }

    public static Method getAssignmentCompatibleMethod(Class<?> clazz, String candidateMethodName, Class<?>[] candidateParameterTypes) throws NoSuchMethodException {
        block8: {
            if (LOG.isDebugEnabled()) {
                StringBuilder buf = new StringBuilder();
                buf.append("call to getAssignmentCompatibleMethod(): \n\tclazz = ");
                buf.append(clazz.getName());
                buf.append("\n\tcandidateMethodName = ");
                buf.append(candidateMethodName);
                buf.append("\n\tcandidateParameterTypes = ");
                for (Class<?> argClass : candidateParameterTypes) {
                    buf.append("\n\t\t");
                    buf.append(argClass.getName());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(buf.toString());
                }
            }
            try {
                Method exactMethod = clazz.getMethod(candidateMethodName, candidateParameterTypes);
                if (exactMethod != null) {
                    return exactMethod;
                }
            }
            catch (Exception e) {
                if (!LOG.isInfoEnabled()) break block8;
                LOG.info(I18n.msg(I18n.MSG_17009_NO_EXACT_MATCH, candidateMethodName, e));
            }
        }
        Method[] methods = clazz.getMethods();
        for (int mx = 0; mx < methods.length; ++mx) {
            Class<?>[] parameterTypes;
            if (!candidateMethodName.equals(methods[mx].getName()) || (parameterTypes = methods[mx].getParameterTypes()).length != candidateParameterTypes.length) continue;
            for (int px = 0; px < parameterTypes.length && parameterTypes[px].isAssignableFrom(candidateParameterTypes[px]); ++px) {
            }
            return methods[mx];
        }
        throw new NoSuchMethodException(clazz.getName() + "." + candidateMethodName + "(" + Arrays.toString(candidateParameterTypes) + ")");
    }
}

