/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.request;

import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.message.ModifyDnResponse;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyDnRequestHandler
extends LdapRequestHandler<ModifyDnRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(ModifyDnRequestHandler.class);

    @Override
    public void handle(LdapSession session, ModifyDnRequest modifyDnRequest) {
        ModifyDnResponse modifyDnResponse = (ModifyDnResponse)modifyDnRequest.getResultResponse();
        LdapResult result = modifyDnResponse.getLdapResult();
        LOG.debug("Handling modify dn request while ignoring referrals: {}", (Object)modifyDnRequest);
        if (modifyDnRequest.getName().isEmpty()) {
            String msg = "Modify Dn is not allowed on Root DSE.";
            result.setResultCode(ResultCodeEnum.PROTOCOL_ERROR);
            result.setDiagnosticMessage(msg);
            session.getIoSession().write(modifyDnResponse);
            return;
        }
        try {
            SchemaManager schemaManager = session.getCoreSession().getDirectoryService().getSchemaManager();
            Dn newRdn = new Dn(schemaManager, modifyDnRequest.getNewRdn().getName());
            Dn oldRdn = new Dn(schemaManager, modifyDnRequest.getName().getRdn().getName());
            boolean rdnChanged = modifyDnRequest.getNewRdn() != null && !newRdn.equals(oldRdn);
            CoreSession coreSession = session.getCoreSession();
            if (rdnChanged) {
                if (modifyDnRequest.getNewSuperior() != null) {
                    coreSession.moveAndRename(modifyDnRequest);
                } else {
                    coreSession.rename(modifyDnRequest);
                }
            } else if (modifyDnRequest.getNewSuperior() != null) {
                modifyDnRequest.setNewRdn(null);
                coreSession.move(modifyDnRequest);
            } else {
                result.setDiagnosticMessage("Attempt to move entry onto itself.");
                result.setResultCode(ResultCodeEnum.ENTRY_ALREADY_EXISTS);
                result.setMatchedDn(modifyDnRequest.getName());
                session.getIoSession().write(modifyDnResponse);
                return;
            }
            result.setResultCode(ResultCodeEnum.SUCCESS);
            session.getIoSession().write(modifyDnResponse);
        }
        catch (Exception e) {
            this.handleException(session, modifyDnRequest, modifyDnResponse, e);
        }
    }
}

