#!/usr/bin/env bash
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

[logging]
 default = FILE:/var/log/krb5libs.log
 kdc = FILE:/var/log/krb5kdc.log
 admin_server = FILE:/var/log/kadmind.log

[libdefaults]
 default_realm = LABS.TERADATA.COM
 dns_lookup_realm = false
 dns_lookup_kdc = false
 forwardable = true
 allow_weak_crypto = true

[realms]
 LABS.TERADATA.COM = {
  kdc = ${HOST}:${KDC_PORT1}
  admin_server = ${HOST}:${KADMIND_PORT1}
 }
 OTHERLABS.TERADATA.COM = {
  kdc = ${HOST}:${KDC_PORT2}
  admin_server = ${HOST}:${KADMIND_PORT2}
 }