// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.flink;

import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;

import java.util.ArrayList;
import java.util.List;

import static org.apache.flink.table.api.Expressions.$;

public class DorisSinkSQLExample {

    public static void main(String[] args) {
        final StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(1);
        env.setRuntimeMode(RuntimeExecutionMode.BATCH);
        final StreamTableEnvironment tEnv = StreamTableEnvironment.create(env);

        List<Tuple2<String, Integer>> data = new ArrayList<>();
        data.add(new Tuple2<>("doris", 1));
        DataStreamSource<Tuple2<String, Integer>> source = env.fromCollection(data);
        tEnv.createTemporaryView("doris_test", source, $("name"), $("age"));

        tEnv.executeSql(
                "CREATE TABLE doris_test_sink ("
                        + "name STRING,"
                        + "age INT"
                        + ") "
                        + "WITH (\n"
                        + "  'connector' = 'doris',\n"
                        + "  'fenodes' = 'FE_IP:8030',\n"
                        + "  'table.identifier' = 'db.table',\n"
                        + "  'username' = 'root',\n"
                        + "  'password' = '',\n"
                        + "  'sink.properties.format' = 'json',\n"
                        + "  'sink.buffer-count' = '4',\n"
                        + "  'sink.buffer-size' = '4086',"
                        + "  'sink.label-prefix' = 'doris_label',\n"
                        + "  'sink.properties.read_json_by_line' = 'true'\n"
                        + ")");
        tEnv.executeSql("INSERT INTO doris_test_sink select name,age from doris_test");
    }
}
