# dubbo api docs

[中文](./README_ch.md)

Dubbo api documents, test tools, generate documents according to annotations, and provide test functions

Adding some annotations can generate a swagger like document without turning a non web Dubbo project into a web project

## Involving repositorys

* [dubbo-spi-extensions](https://github.com/apache/dubbo-spi-extensions)
  [\branch: 2.7.x\dubbo-api-docs](https://github.com/apache/dubbo-spi-extensions/tree/2.7.x/dubbo-api-docs):
  Dubbo-Api-Docs related annotation ,annotation parsing
* [dubbo-admin](https://github.com/KeRan213539/dubbo-admin): Dubbo-Api-Docs document display, test function

## How to use?

1. Dubbo api docs annotation added to method parameters of Dubbo project
    * Dubbo provider project introduces dubbo-api-docs-core
    * If Dubbo's interface and parameters are a separate jar package project, introduce dubbo-api-docs-annotations
    * Add the annotation @EnableDubboApiDocs to the project startup class (marked with @SpringBootApplication)
      or configuration class (marked with @Configuration) of the provider project to enable the Dubbo API Docs
        * In order to avoid increasing the resource consumption in the production environment, it is recommended to
          create a configuration class to enable Dubbo API Docs, and use it with the @Profile("dev") annotation
        * Of course, Dubbo API Docs consumed a little CPU resources when the project starting and used a little memory
          for caching. In the future, it will consider putting the contents of the cache into the metadata center

### Current Version: 2.7.8.3

```
<dependency>
    <groupId>org.apache.dubbo</groupId>
    <artifactId>dubbo-api-docs-annotations</artifactId>
    <version>${dubbo-api-docs-version}</version>
</dependency>

<dependency>
    <groupId>org.apache.dubbo</groupId>
    <artifactId>dubbo-api-docs-core</artifactId>
    <version>${dubbo-api-docs-version}</version>
</dependency>
```

2.

Download [dubbo-admin](https://github.com/apache/dubbo-admin) [Download](https://github.com/apache/dubbo-admin/releases)

3. Start dubbo-admin

4. Visit: http:// localhost:8080

5. Enter the "API Doc" module

### Annotation use

* @EnableDubboApiDocs: 配制注解, 启用 dubbo api docs 功能
* @ApiModule: class annotation, dubbo API module information, used to mark the purpose of an interface class module
    * value: module name
    * apiInterface: Provider implemented interface
    * ~~version: module version~~
* @ApiDoc: method annotation, dubbo API information, used to mark the purpose of an dubbo API
    * value: API name
    * description: API description(HTML tags available)
    * ~~version: API version~~
    * responseClassDescription: response class description
* @RequestParam: class property/method Parameter annotation, mark request parameters
    * value: parameter name
    * required: true/false required parameter
    * description: parameter description
    * example: parameter example
    * defaultValue: parameter default value
    * allowableValues: Allowed values. After setting this property, a drop-down list will be generated for the parameter
        * Note: a drop-down selection box will be generated after using this property
        * Parameters of boolean type do not need to be set with this property. A drop-down list of true / false will be
          generated by default
        * Parameters of enumeration type will automatically generate a drop-down list. If you do not want to open all
          enumeration values, you can set this property separately.
* @ResponseProperty: Class attribute annotation, mark response parameters
    * value: parameter name
    * example: example

### Use note

* Get API list direct connection:

> Because Dubbo services with different functions may be registered in the same registration center,
> but the name of the interface used by Dubbo doc is the same, so the interface of Dubbo doc uses direct connection to obtain the list of different interfaces of different functions.
> The test can be connected directly or through the registration center

* The response bean (the return type of the interface) supports custom generics, but only one generic placeholder.
* About the use of Map: the key of map can only use the basic data type. If the key of map is not the basic data type,
  the generated key is not in the standard JSON format, and an exception will occur
* The API's synchronous / asynchronous is from org.apache.dubbo.config.annotation.Service.async

## Project structure

* dubbo-api-docs-annotations: Document generation annotation project
* dubbo-api-docs-core: Responsible for annotation analysis and document information acquisition interface (Dubbo API)
* dubbo-api-docs-examples: Use example
* readmeImgs: Pictures used by README.md

## Screenshot

![Screenshot](./readmeImgs/dubbo_docs_en.png)
