/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.deploymentadmin.BundleInfo;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.DeploymentPackage;

public class GetStorageAreaCommand
extends Command {
    private final Map m_storageAreas = new HashMap();

    protected void doExecute(DeploymentSessionImpl session) throws Exception {
        DeploymentPackage target = session.getTargetDeploymentPackage();
        BundleInfo[] infos = target.getBundleInfos();
        for (int i = 0; i < infos.length; ++i) {
            if (this.isCancelled()) {
                throw new DeploymentException(401);
            }
            Bundle bundle = target.getBundle(infos[i].getSymbolicName());
            if (bundle == null) continue;
            try {
                File root = session.getDataFile(bundle);
                this.m_storageAreas.put(bundle.getSymbolicName(), root);
                continue;
            }
            catch (IllegalStateException ise) {
                session.getLog().log(2, "Could not get reference to storage area of bundle '" + bundle.getSymbolicName() + "'");
            }
        }
    }

    public Map getStorageAreas() {
        return this.m_storageAreas;
    }
}

