/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.abc;

import org.apache.flex.abc.semantics.Metadata;
import org.apache.flex.abc.visitors.IMetadataVisitor;
import org.apache.flex.abc.visitors.ITraitVisitor;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.IFunctionDefinition;
import org.apache.flex.compiler.definitions.metadata.IMetaTag;
import org.apache.flex.compiler.definitions.metadata.IMetaTagAttribute;
import org.apache.flex.compiler.internal.definitions.ClassDefinition;
import org.apache.flex.compiler.internal.definitions.DefinitionBase;
import org.apache.flex.compiler.internal.definitions.FunctionDefinition;
import org.apache.flex.compiler.internal.definitions.metadata.MetaTag;
import org.apache.flex.compiler.internal.definitions.metadata.MetaTagAttribute;

class CollectMetadataTraitVisitor
implements ITraitVisitor {
    private final DefinitionBase definition;
    private IMetaTag[] metaTags;

    CollectMetadataTraitVisitor(DefinitionBase definition) {
        assert (definition != null);
        this.definition = definition;
    }

    @Override
    public IMetadataVisitor visitMetadata(int count) {
        assert (this.metaTags == null) : "Can not re-use the collector.";
        this.metaTags = new IMetaTag[count];
        return new IMetadataVisitor(){
            int currentIndex = 0;

            @Override
            public void visit(Metadata metadata) {
                ((CollectMetadataTraitVisitor)CollectMetadataTraitVisitor.this).metaTags[this.currentIndex++] = CollectMetadataTraitVisitor.createMetaTag(CollectMetadataTraitVisitor.this.definition, metadata);
            }
        };
    }

    @Override
    public void visitStart() {
    }

    private IMetaTag findMetaTag(String name) {
        for (IMetaTag tag : this.metaTags) {
            if (!tag.getTagName().equals(name)) continue;
            return tag;
        }
        return null;
    }

    private static void setNameLocation(IDefinition def, IMetaTag gotoDefTag) {
        String posString = gotoDefTag.getAttributeValue("pos");
        int nameStart = Integer.parseInt(posString);
        DefinitionBase constructorDef = (DefinitionBase)def;
        int nameEnd = nameStart + def.getBaseName().length();
        constructorDef.setNameLocation(nameStart, nameEnd);
    }

    @Override
    public void visitEnd() {
        IMetaTag gotoDefHelpTag;
        IMetaTag ctorGotoDefHelpTag;
        ClassDefinition classDef;
        IFunctionDefinition constructor;
        if (this.metaTags == null) {
            this.metaTags = new IMetaTag[0];
        }
        if (this.definition instanceof ClassDefinition && (constructor = (classDef = (ClassDefinition)this.definition).getConstructor()) != null && (ctorGotoDefHelpTag = this.findMetaTag("__go_to_ctor_definition_help")) != null) {
            CollectMetadataTraitVisitor.setNameLocation(constructor, ctorGotoDefHelpTag);
        }
        if ((gotoDefHelpTag = this.findMetaTag("__go_to_definition_help")) != null) {
            CollectMetadataTraitVisitor.setNameLocation(this.definition, gotoDefHelpTag);
        }
        this.definition.setMetaTags(this.metaTags);
    }

    @Override
    public void visitAttribute(String attr_name, Object attr_value) {
        if (this.definition instanceof FunctionDefinition) {
            if (attr_name.equals("final") && ((Boolean)attr_value).booleanValue()) {
                this.definition.setFinal();
            } else if (attr_name.equals("override") && ((Boolean)attr_value).booleanValue()) {
                this.definition.setOverride();
            }
        }
    }

    private static IMetaTag createMetaTag(IDefinition definition, Metadata metadata) {
        String[] keys = metadata.getKeys();
        String[] values = metadata.getValues();
        assert (keys.length == values.length);
        int attributesCount = keys.length;
        IMetaTagAttribute[] attributes = new IMetaTagAttribute[attributesCount];
        for (int i = 0; i < attributesCount; ++i) {
            attributes[i] = new MetaTagAttribute(keys[i], values[i]);
        }
        return new MetaTag(definition, metadata.getName(), attributes);
    }
}

