/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.fxg.swf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flex.compiler.internal.fxg.dom.PathNode;
import org.apache.flex.compiler.internal.fxg.dom.strokes.AbstractStrokeNode;
import org.apache.flex.compiler.problems.FXGInvalidPathDataProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.swf.ISWFConstants;
import org.apache.flex.swf.types.CurvedEdgeRecord;
import org.apache.flex.swf.types.LineStyle;
import org.apache.flex.swf.types.LineStyle2;
import org.apache.flex.swf.types.Rect;
import org.apache.flex.swf.types.ShapeRecord;
import org.apache.flex.swf.types.StraightEdgeRecord;
import org.apache.flex.swf.types.StyleChangeRecord;
import org.apache.flex.swf.types.Styles;

public class ShapeHelper
implements ISWFConstants {
    private static final int MAX_EDGE_SIZE = 65535;

    public static List<ShapeRecord> line(double startX, double startY, double endX, double endY) {
        ArrayList<ShapeRecord> shapeRecords = new ArrayList<ShapeRecord>();
        shapeRecords.add(ShapeHelper.move(startX, startY));
        shapeRecords.addAll(ShapeHelper.straightEdge(startX, startY, endX, endY));
        return shapeRecords;
    }

    public static List<ShapeRecord> implicitClosepath(double startX, double startY, double endX, double endY) {
        ArrayList<ShapeRecord> shapeRecords = new ArrayList<ShapeRecord>();
        StyleChangeRecord scr = ShapeHelper.move(startX, startY);
        scr.defaultStyles(false, false, true);
        shapeRecords.add(scr);
        shapeRecords.addAll(ShapeHelper.straightEdge(startX, startY, endX, endY));
        return shapeRecords;
    }

    public static List<ShapeRecord> rectangle(double startX, double startY, double width, double height) {
        ArrayList<ShapeRecord> shapeRecords = new ArrayList<ShapeRecord>();
        shapeRecords.add(ShapeHelper.move(startX, startY));
        shapeRecords.addAll(ShapeHelper.straightEdge(startX, startY, width, startY));
        shapeRecords.addAll(ShapeHelper.straightEdge(width, startY, width, height));
        shapeRecords.addAll(ShapeHelper.straightEdge(width, height, startX, height));
        shapeRecords.addAll(ShapeHelper.straightEdge(startX, height, startX, startY));
        return shapeRecords;
    }

    public static List<ShapeRecord> rectangle(double startx, double starty, double width, double height, double radiusX, double radiusY, double topLeftRadiusX, double topLeftRadiusY, double topRightRadiusX, double topRightRadiusY, double bottomLeftRadiusX, double bottomLeftRadiusY, double bottomRightRadiusX, double bottomRightRadiusY) {
        double SIN_67_5 = 0.923879532511;
        double SIN_22_5 = 0.382683432365;
        double SIN_45_0 = 0.707106781187;
        ArrayList<ShapeRecord> shapeRecords = new ArrayList<ShapeRecord>();
        if (radiusX == 0.0) {
            radiusX = 0.0;
            radiusY = 0.0;
        } else if (radiusY == 0.0) {
            radiusY = radiusX;
        }
        if (radiusX > width / 2.0) {
            radiusX = width / 2.0;
        }
        if (radiusY > height / 2.0) {
            radiusY = height / 2.0;
        }
        double[] topLeftRadius = ShapeHelper.getCornerRadius(topLeftRadiusX, topLeftRadiusY, radiusX, radiusY, width, height);
        topLeftRadiusX = topLeftRadius[0];
        topLeftRadiusY = topLeftRadius[1];
        double[] topRightRadius = ShapeHelper.getCornerRadius(topRightRadiusX, topRightRadiusY, radiusX, radiusY, width, height);
        topRightRadiusX = topRightRadius[0];
        topRightRadiusY = topRightRadius[1];
        double[] bottomLeftRadius = ShapeHelper.getCornerRadius(bottomLeftRadiusX, bottomLeftRadiusY, radiusX, radiusY, width, height);
        bottomLeftRadiusX = bottomLeftRadius[0];
        bottomLeftRadiusY = bottomLeftRadius[1];
        double[] bottomRightRadius = ShapeHelper.getCornerRadius(bottomRightRadiusX, bottomRightRadiusY, radiusX, radiusY, width, height);
        bottomRightRadiusX = bottomRightRadius[0];
        bottomRightRadiusY = bottomRightRadius[1];
        double c0 = 0.923879532511;
        double c1 = 0.382683432365;
        double c3 = 0.707106781187;
        double rx = bottomRightRadiusX;
        double ry = bottomRightRadiusY;
        double tx = rx / 0.923879532511;
        double ty = ry / 0.923879532511;
        double dx = startx + width - rx;
        double dy = starty + height - ry;
        shapeRecords.add(ShapeHelper.move(dx + rx, dy));
        double currentx = dx + rx;
        double currenty = dy;
        if (bottomRightRadiusX != 0.0) {
            shapeRecords.add(ShapeHelper.curvedEdge(currentx, currenty, dx + c0 * tx, dy + c1 * ty, dx + c3 * rx, dy + c3 * ry));
            shapeRecords.add(ShapeHelper.curvedEdge(dx + c3 * rx, dy + c3 * ry, dx + c1 * tx, dy + c0 * ty, dx, dy + ry));
            currentx = dx;
            currenty = dy + ry;
        }
        rx = bottomLeftRadiusX;
        ry = bottomLeftRadiusY;
        tx = rx / 0.923879532511;
        ty = ry / 0.923879532511;
        dx = startx + rx;
        dy = starty + height - ry;
        shapeRecords.addAll(ShapeHelper.straightEdge(currentx, currenty, dx, dy + ry));
        currentx = dx;
        currenty = dy + ry;
        if (bottomLeftRadiusX != 0.0) {
            shapeRecords.add(ShapeHelper.curvedEdge(currentx, currenty, dx - c1 * tx, dy + c0 * ty, dx - c3 * rx, dy + c3 * ry));
            shapeRecords.add(ShapeHelper.curvedEdge(dx - c3 * rx, dy + c3 * ry, dx - c0 * tx, dy + c1 * ty, dx - rx, dy));
            currentx = dx - rx;
            currenty = dy;
        }
        rx = topLeftRadiusX;
        ry = topLeftRadiusY;
        tx = rx / 0.923879532511;
        ty = ry / 0.923879532511;
        dx = startx + rx;
        dy = starty + ry;
        shapeRecords.addAll(ShapeHelper.straightEdge(currentx, currenty, dx - rx, dy));
        currentx = dx - rx;
        currenty = dy;
        if (topLeftRadiusX != 0.0) {
            shapeRecords.add(ShapeHelper.curvedEdge(currentx, currenty, dx - c0 * tx, dy - c1 * ty, dx - c3 * rx, dy - c3 * ry));
            shapeRecords.add(ShapeHelper.curvedEdge(dx - c3 * rx, dy - c3 * ry, dx - c1 * tx, dy - c0 * ty, dx, dy - ry));
            currentx = dx;
            currenty = dy - ry;
        }
        rx = topRightRadiusX;
        ry = topRightRadiusY;
        tx = rx / 0.923879532511;
        ty = ry / 0.923879532511;
        dx = startx + width - rx;
        dy = starty + ry;
        shapeRecords.addAll(ShapeHelper.straightEdge(currentx, currenty, dx, dy - ry));
        currentx = dx;
        currenty = dy - ry;
        if (topRightRadiusX != 0.0) {
            shapeRecords.add(ShapeHelper.curvedEdge(currentx, currenty, dx + c1 * tx, dy - c0 * ty, dx + c3 * rx, dy - c3 * ry));
            shapeRecords.add(ShapeHelper.curvedEdge(dx + c3 * rx, dy - c3 * ry, dx + c0 * tx, dy - c1 * ty, dx + rx, dy));
            currentx = dx + rx;
            currenty = dy;
        }
        rx = bottomRightRadiusX;
        ry = bottomRightRadiusY;
        tx = rx / 0.923879532511;
        ty = ry / 0.923879532511;
        dx = startx + width - rx;
        dy = starty + height - ry;
        shapeRecords.addAll(ShapeHelper.straightEdge(currentx, currenty, dx + rx, dy));
        return shapeRecords;
    }

    public static List<ShapeRecord> rectangle(double width, double height) {
        return ShapeHelper.rectangle(0.0, 0.0, width, height);
    }

    public static void setStyles(List<ShapeRecord> shapeRecords, int lineStyleIndex, int fillStyle0Index, int fillStyle1Index, Styles styles) {
        ShapeRecord firstRecord;
        int ls;
        int fs0 = fillStyle0Index == 0 ? -1 : fillStyle0Index;
        int fs1 = fillStyle1Index == 0 ? -1 : fillStyle1Index;
        int n = ls = lineStyleIndex == 0 ? -1 : lineStyleIndex;
        if (shapeRecords != null && shapeRecords.size() > 0 && (firstRecord = shapeRecords.get(0)) instanceof StyleChangeRecord) {
            StyleChangeRecord scr = (StyleChangeRecord)firstRecord;
            scr.setDefinedStyles(fs0, fs1, ls, styles);
        }
    }

    public static void setPathStyles(List<ShapeRecord> shapeRecords, int lineStyleIndex, int fillStyle0Index, int fillStyle1Index, Styles styles) {
        int ls;
        int fs0 = fillStyle0Index == 0 ? -1 : fillStyle0Index;
        int fs1 = fillStyle1Index == 0 ? -1 : fillStyle1Index;
        int n = ls = lineStyleIndex == 0 ? -1 : lineStyleIndex;
        if (shapeRecords != null && shapeRecords.size() > 0) {
            for (int i = 0; i < shapeRecords.size(); ++i) {
                StyleChangeRecord scr;
                ShapeRecord record = shapeRecords.get(i);
                if (!(record instanceof StyleChangeRecord)) continue;
                scr.setDefinedStyles(fs0, fs1, !(scr = (StyleChangeRecord)record).isStateLineStyle() && ls > 0 ? ls : -1, styles);
            }
        }
    }

    public static void replaceStyles(List<ShapeRecord> shapeRecords, int lineStyleIndex, int fillStyle0Index, int fillStyle1Index, Styles styleContext) {
        int ls;
        int fs0 = fillStyle0Index == 0 ? -1 : fillStyle0Index;
        int fs1 = fillStyle1Index == 0 ? -1 : fillStyle1Index;
        int n = ls = lineStyleIndex == 0 ? -1 : lineStyleIndex;
        if (shapeRecords != null && shapeRecords.size() > 0) {
            for (int i = 0; i < shapeRecords.size(); ++i) {
                ShapeRecord record = shapeRecords.get(i);
                if (!(record instanceof StyleChangeRecord)) continue;
                StyleChangeRecord old_scr = (StyleChangeRecord)record;
                StyleChangeRecord new_scr = new StyleChangeRecord();
                int old_scrLineStyleIndex = 0;
                if (old_scr.getLinestyle() != null) {
                    old_scrLineStyleIndex = styleContext.getLineStyles().indexOf(old_scr.getLinestyle());
                }
                new_scr.setDefinedStyles(fs0, fs1, !old_scr.isStateLineStyle() && ls > 0 ? ls : old_scrLineStyleIndex, styleContext);
                if (old_scr.isStateMoveTo()) {
                    new_scr.setMove(old_scr.getMoveDeltaX(), old_scr.getMoveDeltaY());
                }
                shapeRecords.set(i, new_scr);
            }
        }
    }

    public static StyleChangeRecord move(double x, double y) {
        int moveX = (int)(x *= 20.0);
        int moveY = (int)(y *= 20.0);
        StyleChangeRecord scr = new StyleChangeRecord();
        scr.setMove(moveX, moveY);
        return scr;
    }

    public static List<ShapeRecord> straightEdge(double xFrom, double yFrom, double xTo, double yTo) {
        ArrayList<ShapeRecord> shapeRecords = new ArrayList<ShapeRecord>();
        int dx = (int)(xTo *= 20.0) - (int)(xFrom *= 20.0);
        int dy = (int)(yTo *= 20.0) - (int)(yFrom *= 20.0);
        int abs_dx = Math.abs(dx);
        int abs_dy = Math.abs(dy);
        int numSegments = 1;
        if (abs_dx > 65535 && abs_dx > abs_dy) {
            numSegments = abs_dx / 65535 + 1;
        } else if (abs_dy > 65535 && abs_dy > abs_dx) {
            numSegments = abs_dy / 65535 + 1;
        } else {
            StraightEdgeRecord ser = new StraightEdgeRecord(dx, dy);
            shapeRecords.add(ser);
            return shapeRecords;
        }
        int xSeg = dx / numSegments;
        int ySeg = dy / numSegments;
        for (int i = 0; i < numSegments; ++i) {
            if (i == numSegments - 1) {
                int lastx = dx - xSeg * (numSegments - 1);
                int lasty = dy - ySeg * (numSegments - 1);
                StraightEdgeRecord ser = new StraightEdgeRecord(lastx, lasty);
                shapeRecords.add(ser);
                continue;
            }
            StraightEdgeRecord ser = new StraightEdgeRecord(xSeg, ySeg);
            shapeRecords.add(ser);
        }
        return shapeRecords;
    }

    public static CurvedEdgeRecord curvedEdge(double startX, double startY, double controlX, double controlY, double anchorX, double anchorY) {
        int dcx = (int)(controlX *= 20.0) - (int)(startX *= 20.0);
        int dcy = (int)(controlY *= 20.0) - (int)(startY *= 20.0);
        int dax = (int)(anchorX *= 20.0) - (int)controlX;
        int day = (int)(anchorY *= 20.0) - (int)controlY;
        CurvedEdgeRecord cer = new CurvedEdgeRecord();
        cer.setControlDeltaX(dcx);
        cer.setControlDeltaY(dcy);
        cer.setAnchorDeltaX(dax);
        cer.setAnchorDeltaY(day);
        return cer;
    }

    public static List<ShapeRecord> cubicToQuadratic(double startX, double startY, double control1X, double control1Y, double control2X, double control2Y, double anchorX, double anchorY) {
        double ratio = 0.75;
        double pax = startX + (control1X - startX) * ratio;
        double pay = startY + (control1Y - startY) * ratio;
        double pbx = anchorX + (control2X - anchorX) * ratio;
        double pby = anchorY + (control2Y - anchorY) * ratio;
        double dx = (anchorX - startX) / 16.0;
        double dy = (anchorY - startY) / 16.0;
        ratio = 0.375;
        double c1x = startX + (control1X - startX) * ratio;
        double c1y = startY + (control1Y - startY) * ratio;
        double c2x = pax + (pbx - pax) * ratio;
        double c2y = pay + (pby - pay) * ratio;
        c2x -= dx;
        c2y -= dy;
        double c3x = pbx + (pax - pbx) * ratio;
        double c3y = pby + (pay - pby) * ratio;
        c3x += dx;
        c3y += dy;
        double c4x = anchorX + (control2X - anchorX) * ratio;
        double c4y = anchorY + (control2Y - anchorY) * ratio;
        double a1x = (c1x + c2x) / 2.0;
        double a1y = (c1y + c2y) / 2.0;
        double a2x = (pax + pbx) / 2.0;
        double a2y = (pay + pby) / 2.0;
        double a3x = (c3x + c4x) / 2.0;
        double a3y = (c3y + c4y) / 2.0;
        ArrayList<ShapeRecord> shapeRecords = new ArrayList<ShapeRecord>(4);
        shapeRecords.add(ShapeHelper.curvedEdge(startX, startY, c1x, c1y, a1x, a1y));
        shapeRecords.add(ShapeHelper.curvedEdge(a1x, a1y, c2x, c2y, a2x, a2y));
        shapeRecords.add(ShapeHelper.curvedEdge(a2x, a2y, c3x, c3y, a3x, a3y));
        shapeRecords.add(ShapeHelper.curvedEdge(a3x, a3y, c4x, c4y, anchorX, anchorY));
        return shapeRecords;
    }

    public static List<ShapeRecord> path(PathNode node, boolean fill, Collection<ICompilerProblem> problems) {
        String data = node.data;
        ArrayList<ShapeRecord> shapeRecords = new ArrayList<ShapeRecord>();
        if (data.length() == 0) {
            return shapeRecords;
        }
        String temp = data.replaceAll("([A-Za-z])([0-9\\-\\.])", "$1 $2");
        temp = temp.replaceAll("([0-9\\.])([A-Za-z\\-])", "$1 $2");
        temp = temp.replaceAll("([A-Za-z\\-])([A-Za-z\\-])", "$1 $2");
        temp = temp.replaceAll("([0-9])( )([eE])( )([0-9\\-])", "$1$3$5");
        temp = temp.replace(',', ' ');
        temp = temp.trim();
        String[] args = temp.split("\\s+");
        int ic = 0;
        int prevIc = 0;
        double lastMoveX = 0.0;
        double lastMoveY = 0.0;
        double prevX = 0.0;
        double prevY = 0.0;
        double x = 0.0;
        double y = 0.0;
        double controlX = 0.0;
        double controlY = 0.0;
        double control2X = 0.0;
        double control2Y = 0.0;
        boolean firstMove = true;
        int i = 0;
        while (i < args.length) {
            boolean relative = false;
            int c = args[i].toCharArray()[0];
            if (c >= 65 && c <= 90 || c >= 97 && c <= 122) {
                ic = c;
                ++i;
            }
            if (firstMove && ic != 109 && ic != 77) {
                problems.add(new FXGInvalidPathDataProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn()));
                return Collections.emptyList();
            }
            switch (ic) {
                case 109: {
                    relative = true;
                }
                case 77: {
                    if (firstMove) {
                        x = Double.parseDouble(args[i++]);
                        y = Double.parseDouble(args[i++]);
                        shapeRecords.add(ShapeHelper.move(x, y));
                        firstMove = false;
                    } else {
                        if (fill && (Math.abs(prevX - lastMoveX) > 1.0E-5 || Math.abs(prevY - lastMoveY) > 1.0E-5)) {
                            if (node.stroke == null) {
                                shapeRecords.addAll(ShapeHelper.straightEdge(prevX, prevY, lastMoveX, lastMoveY));
                            } else {
                                shapeRecords.addAll(ShapeHelper.implicitClosepath(prevX, prevY, lastMoveX, lastMoveY));
                            }
                        }
                        x = Double.parseDouble(args[i++]) + (relative ? prevX : 0.0);
                        y = Double.parseDouble(args[i++]) + (relative ? prevY : 0.0);
                        shapeRecords.add(ShapeHelper.move(x, y));
                    }
                    lastMoveX = x;
                    lastMoveY = y;
                    ic = relative ? 108 : 76;
                    break;
                }
                case 108: {
                    relative = true;
                }
                case 76: {
                    x = Double.parseDouble(args[i++]) + (relative ? prevX : 0.0);
                    y = Double.parseDouble(args[i++]) + (relative ? prevY : 0.0);
                    shapeRecords.addAll(ShapeHelper.straightEdge(prevX, prevY, x, y));
                    break;
                }
                case 104: {
                    relative = true;
                }
                case 72: {
                    x = Double.parseDouble(args[i++]) + (relative ? prevX : 0.0);
                    y = prevY;
                    shapeRecords.addAll(ShapeHelper.straightEdge(prevX, prevY, x, y));
                    break;
                }
                case 118: {
                    relative = true;
                }
                case 86: {
                    x = prevX;
                    y = Double.parseDouble(args[i++]) + (relative ? prevY : 0.0);
                    shapeRecords.addAll(ShapeHelper.straightEdge(prevX, prevY, x, y));
                    break;
                }
                case 113: {
                    relative = true;
                }
                case 81: {
                    controlX = Double.parseDouble(args[i++]) + (relative ? prevX : 0.0);
                    controlY = Double.parseDouble(args[i++]) + (relative ? prevY : 0.0);
                    x = Double.parseDouble(args[i++]) + (relative ? prevX : 0.0);
                    y = Double.parseDouble(args[i++]) + (relative ? prevY : 0.0);
                    shapeRecords.add(ShapeHelper.curvedEdge(prevX, prevY, controlX, controlY, x, y));
                    break;
                }
                case 116: {
                    relative = true;
                }
                case 84: {
                    if (prevIc == 84 || prevIc == 116 || prevIc == 113 || prevIc == 81) {
                        controlX = prevX + (prevX - controlX);
                        controlY = prevY + (prevY - controlY);
                    } else {
                        controlX = prevX;
                        controlY = prevY;
                    }
                    x = Double.parseDouble(args[i++]) + (relative ? prevX : 0.0);
                    y = Double.parseDouble(args[i++]) + (relative ? prevY : 0.0);
                    shapeRecords.add(ShapeHelper.curvedEdge(prevX, prevY, controlX, controlY, x, y));
                    break;
                }
                case 99: {
                    relative = true;
                }
                case 67: {
                    controlX = Double.parseDouble(args[i++]) + (relative ? prevX : 0.0);
                    controlY = Double.parseDouble(args[i++]) + (relative ? prevY : 0.0);
                    control2X = Double.parseDouble(args[i++]) + (relative ? prevX : 0.0);
                    control2Y = Double.parseDouble(args[i++]) + (relative ? prevY : 0.0);
                    x = Double.parseDouble(args[i++]) + (relative ? prevX : 0.0);
                    y = Double.parseDouble(args[i++]) + (relative ? prevY : 0.0);
                    shapeRecords.addAll(ShapeHelper.cubicToQuadratic(prevX, prevY, controlX, controlY, control2X, control2Y, x, y));
                    break;
                }
                case 115: {
                    relative = true;
                }
                case 83: {
                    if (prevIc == 83 || prevIc == 115 || prevIc == 99 || prevIc == 67) {
                        controlX = prevX + (prevX - control2X);
                        controlY = prevY + (prevY - control2Y);
                    } else {
                        controlX = prevX;
                        controlY = prevY;
                    }
                    control2X = Double.parseDouble(args[i++]) + (relative ? prevX : 0.0);
                    control2Y = Double.parseDouble(args[i++]) + (relative ? prevY : 0.0);
                    x = Double.parseDouble(args[i++]) + (relative ? prevX : 0.0);
                    y = Double.parseDouble(args[i++]) + (relative ? prevY : 0.0);
                    shapeRecords.addAll(ShapeHelper.cubicToQuadratic(prevX, prevY, controlX, controlY, control2X, control2Y, x, y));
                    break;
                }
                case 90: 
                case 122: {
                    shapeRecords.addAll(ShapeHelper.straightEdge(prevX, prevY, lastMoveX, lastMoveY));
                    x = lastMoveX;
                    y = lastMoveY;
                    break;
                }
                default: {
                    problems.add(new FXGInvalidPathDataProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn()));
                    return Collections.emptyList();
                }
            }
            prevX = x;
            prevY = y;
            prevIc = ic;
        }
        if (fill && Math.abs(prevX - lastMoveX) > 1.0E-5 || Math.abs(prevY - lastMoveY) > 1.0E-5) {
            if (node.stroke == null) {
                shapeRecords.addAll(ShapeHelper.straightEdge(prevX, prevY, lastMoveX, lastMoveY));
            } else {
                shapeRecords.addAll(ShapeHelper.implicitClosepath(prevX, prevY, lastMoveX, lastMoveY));
            }
        }
        return shapeRecords;
    }

    public static Rect getBounds(List<ShapeRecord> records, LineStyle ls, AbstractStrokeNode strokeNode) {
        if (records == null || records.size() == 0) {
            assert (false) : "null records";
            return new Rect(0, 0);
        }
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        int x = 0;
        int y = 0;
        boolean firstMove = true;
        for (ShapeRecord r : records) {
            if (r == null) continue;
            if (r instanceof StyleChangeRecord) {
                StyleChangeRecord scr = (StyleChangeRecord)r;
                x = scr.getMoveDeltaX();
                y = scr.getMoveDeltaY();
                scr.setMove(x, y);
                if (firstMove) {
                    x1 = x;
                    y1 = y;
                    x2 = x;
                    y2 = y;
                    firstMove = false;
                }
            } else if (r instanceof StraightEdgeRecord) {
                StraightEdgeRecord ser = (StraightEdgeRecord)r;
                x += ser.getDeltaX();
                y += ser.getDeltaY();
            } else if (r instanceof CurvedEdgeRecord) {
                CurvedEdgeRecord cer = (CurvedEdgeRecord)r;
                Rect currRect = new Rect(x1, x2, y1, y2);
                if (!ShapeHelper.curveControlPointInsideCurrentRect(x, y, cer, currRect)) {
                    Rect curvBounds = ShapeHelper.computeCurveBounds(x, y, cer);
                    if (curvBounds.xMin() < x1) {
                        x1 = curvBounds.xMin();
                    }
                    if (curvBounds.yMin() < y1) {
                        y1 = curvBounds.yMin();
                    }
                    if (curvBounds.xMax() > x2) {
                        x2 = curvBounds.xMax();
                    }
                    if (curvBounds.yMax() > y2) {
                        y2 = curvBounds.yMax();
                    }
                }
                x = x + cer.getControlDeltaX() + cer.getAnchorDeltaX();
                y = y + cer.getControlDeltaY() + cer.getAnchorDeltaY();
            }
            if (x < x1) {
                x1 = x;
            }
            if (y < y1) {
                y1 = y;
            }
            if (x > x2) {
                x2 = x;
            }
            if (y <= y2) continue;
            y2 = y;
        }
        Rect newRect = new Rect(x1, x2, y1, y2);
        if (ls == null) {
            return newRect;
        }
        Rect strokeExtents = ShapeHelper.getStrokeExtents(strokeNode, ls);
        newRect = new Rect(newRect.xMin() - strokeExtents.xMax(), newRect.xMax() + strokeExtents.xMax(), newRect.yMin() - strokeExtents.yMax(), newRect.yMax() + strokeExtents.yMax());
        if (ls instanceof LineStyle2 && (records.size() < 2 || ls == null || ((LineStyle2)ls).getJoinStyle() != 2)) {
            return newRect;
        }
        double halfWeight = (double)(strokeExtents.xMax() - strokeExtents.xMin()) / 2.0;
        newRect = ShapeHelper.addJoint2Bounds(records, ls, strokeNode, halfWeight, newRect);
        return newRect;
    }

    public static Rect addJoint2Bounds(List<ShapeRecord> records, LineStyle ls, AbstractStrokeNode stroke, double halfWeight, Rect pathBBox) {
        Rect newRect = pathBBox;
        int count = records.size();
        int start = 0;
        int end = 0;
        int lastMoveX = 0;
        int lastMoveY = 0;
        int lastOpenSegment = 0;
        int x = 0;
        int y = 0;
        double miterLimit = stroke.miterLimit;
        if (miterLimit < 1.0) {
            miterLimit = 1.0;
        }
        int[][] cooridinates = ShapeHelper.getCoordinates(records);
        while (true) {
            if (start < count && !(records.get(start) instanceof StyleChangeRecord)) {
                x = cooridinates[start - 1][0];
                y = cooridinates[start - 1][1];
                if (!ShapeHelper.tangentIsValid(records.get(start), x, y)) {
                    ++start;
                    continue;
                }
            }
            if (start >= count) break;
            ShapeRecord startSegment = records.get(start);
            if (startSegment instanceof StyleChangeRecord) {
                lastOpenSegment = start + 1;
                lastMoveX = ((StyleChangeRecord)startSegment).getMoveDeltaX();
                lastMoveY = ((StyleChangeRecord)startSegment).getMoveDeltaY();
                ++start;
                continue;
            }
            int startSegmentX = cooridinates[start][0];
            int startSegmentY = cooridinates[start][1];
            for (end = (start == count - 1 || records.get(start + 1) instanceof StyleChangeRecord) && startSegmentX == lastMoveX && startSegmentY == lastMoveY ? lastOpenSegment : start + 1; end < count && !(records.get(end) instanceof StyleChangeRecord) && !ShapeHelper.tangentIsValid(records.get(end), startSegmentX, startSegmentY); ++end) {
            }
            if (end >= count) break;
            ShapeRecord endSegment = records.get(end);
            if (!(endSegment instanceof StyleChangeRecord)) {
                newRect = ShapeHelper.addMiterLimitStrokeToBounds(startSegment, endSegment, miterLimit, halfWeight, newRect, x, y, startSegmentX, startSegmentY);
            }
            start = start > end ? start + 1 : end;
        }
        return newRect;
    }

    private static int[][] getCoordinates(List<ShapeRecord> records) {
        int[][] coordinates = new int[records.size()][2];
        for (int i = 0; i < records.size(); ++i) {
            ShapeRecord record = records.get(i);
            if (record instanceof StyleChangeRecord) {
                StyleChangeRecord scr = (StyleChangeRecord)record;
                coordinates[i][0] = scr.getMoveDeltaX();
                coordinates[i][1] = scr.getMoveDeltaY();
                continue;
            }
            if (record instanceof StraightEdgeRecord) {
                StraightEdgeRecord ser = (StraightEdgeRecord)record;
                coordinates[i][0] = coordinates[i - 1][0] + ser.getDeltaX();
                coordinates[i][1] = coordinates[i - 1][1] + ser.getDeltaY();
                continue;
            }
            if (!(record instanceof CurvedEdgeRecord)) continue;
            CurvedEdgeRecord cer = (CurvedEdgeRecord)record;
            coordinates[i][0] = coordinates[i - 1][0] + cer.getControlDeltaX() + cer.getAnchorDeltaX();
            coordinates[i][1] = coordinates[i - 1][1] + cer.getControlDeltaY() + cer.getAnchorDeltaY();
        }
        return coordinates;
    }

    public static Rect addMiterLimitStrokeToBounds(ShapeRecord segment1, ShapeRecord segment2, double miterLimit, double halfWeight, Rect pathBBox, int xPrev, int yPrev, int x, int y) {
        Point jointPoint = new Point(x, y);
        if (ShapeHelper.isInnerJoint(jointPoint, pathBBox, miterLimit, halfWeight)) {
            return pathBBox;
        }
        Point t0 = ShapeHelper.getTangent(segment1, false, xPrev, yPrev);
        Point t1 = ShapeHelper.getTangent(segment2, true, x, y);
        if (ShapeHelper.getPointLength(t0) == 0.0 || ShapeHelper.getPointLength(t1) == 0.0) {
            return pathBBox;
        }
        t0 = ShapeHelper.normalize(t0, 1.0);
        t0.x = -t0.x;
        t0.y = -t0.y;
        t1 = ShapeHelper.normalize(t1, 1.0);
        Point halfT0T1 = new Point((t1.x - t0.x) * 0.5, (t1.y - t0.y) * 0.5);
        double sinHalfAlpha = ShapeHelper.getPointLength(halfT0T1);
        if (Math.abs(sinHalfAlpha) < 1.0E-9) {
            return pathBBox;
        }
        Point bisect = new Point(-0.5 * (t0.x + t1.x), -0.5 * (t0.y + t1.y));
        double bisectLength = ShapeHelper.getPointLength(bisect);
        if (bisectLength == 0.0) {
            return pathBBox;
        }
        Rect newRect = pathBBox;
        if (sinHalfAlpha == 0.0 || miterLimit < 1.0 / sinHalfAlpha) {
            bisect = ShapeHelper.normalize(bisect, 1.0);
            halfT0T1 = ShapeHelper.normalize(halfT0T1, (halfWeight - miterLimit * halfWeight * sinHalfAlpha) / bisectLength);
            Point pt0 = new Point(jointPoint.x + miterLimit * halfWeight * bisect.x + halfT0T1.x, jointPoint.y + miterLimit * halfWeight * bisect.y + halfT0T1.y);
            Point pt1 = new Point(jointPoint.x + miterLimit * halfWeight * bisect.x - halfT0T1.x, jointPoint.y + miterLimit * halfWeight * bisect.y - halfT0T1.y);
            newRect = ShapeHelper.rectUnion((int)StrictMath.rint(pt0.x), (int)StrictMath.rint(pt0.y), (int)StrictMath.rint(pt0.x), (int)StrictMath.rint(pt0.y), newRect);
            newRect = ShapeHelper.rectUnion((int)StrictMath.rint(pt1.x), (int)StrictMath.rint(pt1.y), (int)StrictMath.rint(pt1.x), (int)StrictMath.rint(pt1.y), newRect);
        } else {
            bisect = ShapeHelper.normalize(bisect, 1.0);
            Point strokeTip = new Point(jointPoint.x + bisect.x * halfWeight / sinHalfAlpha, jointPoint.y + bisect.y * halfWeight / sinHalfAlpha);
            newRect = ShapeHelper.rectUnion((int)StrictMath.rint(strokeTip.x), (int)StrictMath.rint(strokeTip.y), (int)StrictMath.rint(strokeTip.x), (int)StrictMath.rint(strokeTip.y), newRect);
        }
        return newRect;
    }

    private static boolean isInnerJoint(Point jointPoint, Rect pathBBox, double miterLimit, double halfWeight) {
        return jointPoint.x - (double)pathBBox.xMin() > miterLimit * halfWeight && (double)pathBBox.xMax() - jointPoint.x > miterLimit * halfWeight && jointPoint.y - (double)pathBBox.yMin() > miterLimit * halfWeight && (double)pathBBox.yMax() - jointPoint.y > miterLimit * halfWeight;
    }

    private static boolean tangentIsValid(ShapeRecord curSegment, int x, int y) {
        Point tangentPoint = ShapeHelper.getTangent(curSegment, true, x, y);
        return tangentPoint.x != 0.0 || tangentPoint.y != 0.0;
    }

    private static Point getTangent(ShapeRecord curSegment, boolean start, int x, int y) {
        Point tangentPoint = new Point();
        Point pt0 = new Point(x, y);
        if (curSegment instanceof StraightEdgeRecord) {
            Point pt1 = new Point(x + ((StraightEdgeRecord)curSegment).getDeltaX(), y + ((StraightEdgeRecord)curSegment).getDeltaY());
            tangentPoint.x = pt1.x - pt0.x;
            tangentPoint.y = pt1.y - pt0.y;
        } else if (curSegment instanceof CurvedEdgeRecord) {
            Point pt1 = new Point(x + ((CurvedEdgeRecord)curSegment).getControlDeltaX(), y + ((CurvedEdgeRecord)curSegment).getControlDeltaY());
            Point pt2 = new Point(pt1.x + (double)((CurvedEdgeRecord)curSegment).getAnchorDeltaX(), pt1.y + (double)((CurvedEdgeRecord)curSegment).getAnchorDeltaY());
            tangentPoint = ShapeHelper.getQTangent(pt0.x, pt0.y, pt1.x, pt1.y, pt2.x, pt2.y, start);
        }
        return tangentPoint;
    }

    private static Point getQTangent(double x0, double y0, double x1, double y1, double x2, double y2, boolean start) {
        Point tangentPoint = new Point();
        if (start) {
            if (x0 == x1 && y0 == y1) {
                tangentPoint.x = x2 - x0;
                tangentPoint.y = y2 - y0;
            } else {
                tangentPoint.x = x1 - x0;
                tangentPoint.y = y1 - y0;
            }
        } else if (x2 == x1 && y2 == y1) {
            tangentPoint.x = x2 - x0;
            tangentPoint.y = y2 - y0;
        } else {
            tangentPoint.x = x2 - x1;
            tangentPoint.y = y2 - y1;
        }
        return tangentPoint;
    }

    public static Point normalize(Point p, double length) {
        double len = Math.sqrt(p.x * p.x + p.y * p.y);
        return new Point(p.x * (length /= len), p.y * length);
    }

    public static double getPointLength(Point p) {
        double length = p.x == 0.0 ? p.y : Math.sqrt(p.x * p.x + p.y * p.y);
        return length;
    }

    private static Rect rectUnion(int left, int top, int right, int bottom, Rect rect) {
        if (rect == null) {
            return new Rect(left, right, top, bottom);
        }
        return new Rect(Math.min(rect.xMin(), left), Math.max(rect.xMax(), right), Math.min(rect.yMin(), top), Math.max(rect.yMax(), bottom));
    }

    private static Rect getStrokeExtents(AbstractStrokeNode stroke, LineStyle ls) {
        int yMax;
        int yMin;
        int xMax;
        int xMin;
        if (stroke == null) {
            return new Rect(0, 0, 0, 0);
        }
        int lineWidth = ls.getWidth();
        if (lineWidth == 0) {
            xMin = (int)StrictMath.rint(-10.0);
            xMax = (int)StrictMath.rint(10.0);
            yMin = (int)StrictMath.rint(-10.0);
            yMax = (int)StrictMath.rint(10.0);
        } else {
            xMin = (int)StrictMath.rint((double)(-lineWidth) * 0.5);
            xMax = (int)StrictMath.rint((double)lineWidth * 0.5);
            yMin = (int)StrictMath.rint((double)(-lineWidth) * 0.5);
            yMax = (int)StrictMath.rint((double)lineWidth * 0.5);
        }
        return new Rect(xMin, xMax, yMin, yMax);
    }

    private static Rect computeCurveBounds(int x0, int y0, CurvedEdgeRecord curve) {
        int y;
        int x;
        double t;
        int x1 = x0 + curve.getControlDeltaX();
        int y1 = y0 + curve.getControlDeltaY();
        int x2 = x1 + curve.getAnchorDeltaX();
        int y2 = y1 + curve.getAnchorDeltaY();
        int xmin = x0;
        int xmax = x0;
        int ymin = y0;
        int ymax = y0;
        if (x2 < xmin) {
            xmin = x2;
        }
        if (y2 < ymin) {
            ymin = y2;
        }
        if (x2 > xmax) {
            xmax = x2;
        }
        if (y2 > ymax) {
            ymax = y2;
        }
        if (Double.isNaN(t = ShapeHelper.computeTExtrema(x0, x1, x2))) {
            if (x1 < xmin) {
                xmin = x1;
            }
            if (y1 < ymin) {
                ymin = y1;
            }
            if (x1 > xmax) {
                xmax = x1;
            }
            if (y1 > ymax) {
                ymax = y1;
            }
        } else if (t > 0.0 && t < 1.0) {
            x = ShapeHelper.computeValueForCurve(x0, x1, x2, t);
            y = ShapeHelper.computeValueForCurve(y0, y1, y2, t);
            if (x < xmin) {
                xmin = x;
            }
            if (y < ymin) {
                ymin = y;
            }
            if (x > xmax) {
                xmax = x;
            }
            if (y > ymax) {
                ymax = y;
            }
        }
        if (Double.isNaN(t = ShapeHelper.computeTExtrema(y0, y1, y2))) {
            if (x1 < xmin) {
                xmin = x1;
            }
            if (y1 < ymin) {
                ymin = y1;
            }
            if (x1 > xmax) {
                xmax = x1;
            }
            if (y1 > ymax) {
                ymax = y1;
            }
        } else if (t > 0.0 && t < 1.0) {
            x = ShapeHelper.computeValueForCurve(x0, x1, x2, t);
            y = ShapeHelper.computeValueForCurve(y0, y1, y2, t);
            if (x < xmin) {
                xmin = x;
            }
            if (y < ymin) {
                ymin = y;
            }
            if (x > xmax) {
                xmax = x;
            }
            if (y > ymax) {
                ymax = y;
            }
        }
        Rect r = new Rect(xmin, xmax, ymin, ymax);
        return r;
    }

    private static boolean curveControlPointInsideCurrentRect(int x0, int y0, CurvedEdgeRecord curve, Rect currRect) {
        int x = x0 + curve.getControlDeltaX();
        int y = y0 + curve.getControlDeltaY();
        int xmin = x0;
        int xmax = x0;
        int ymin = y0;
        int ymax = y0;
        if (x < xmin) {
            xmin = x;
        }
        if (y < ymin) {
            ymin = y;
        }
        if (x > xmax) {
            xmax = x;
        }
        if (y > ymax) {
            ymax = y;
        }
        return currRect.xMin() < xmin && currRect.xMax() > xmax && currRect.yMin() < ymin && currRect.yMax() > ymax;
    }

    private static int computeValueForCurve(int p0, int p1, int p2, double t) {
        return (int)((double)p0 * (1.0 - t) * (1.0 - t) + (double)(2 * p1) * (1.0 - t) * t + (double)p2 * t * t);
    }

    private static double computeTExtrema(int p0, int p1, int p2) {
        int denom = p0 - 2 * p1 + p2;
        if (denom == 0) {
            return Double.NaN;
        }
        double t = (double)(p0 - p1) / (double)denom;
        return t;
    }

    private static double[] getCornerRadius(double cornerRadiusX, double cornerRadiusY, double radiusX, double radiusY, double width, double height) {
        double[] newRadius = new double[2];
        if (Double.isNaN(cornerRadiusX)) {
            cornerRadiusX = radiusX;
            cornerRadiusY = Double.isNaN(cornerRadiusY) ? radiusY : cornerRadiusX;
        } else if (Double.isNaN(cornerRadiusY)) {
            cornerRadiusY = cornerRadiusX;
        }
        if (cornerRadiusX > width / 2.0) {
            cornerRadiusX = width / 2.0;
        }
        if (cornerRadiusY > height / 2.0) {
            cornerRadiusY = height / 2.0;
        }
        newRadius[0] = cornerRadiusX;
        newRadius[1] = cornerRadiusY;
        return newRadius;
    }

    private static class Point {
        public double x;
        public double y;

        public Point() {
            this.x = 0.0;
            this.y = 0.0;
        }

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

