/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.parsing.mxml;

import org.apache.flex.compiler.internal.parsing.as.ASToken;
import org.apache.flex.compiler.parsing.ICMToken;
import org.apache.flex.compiler.parsing.IMXMLToken;

public class MXMLToken
extends ASToken
implements IMXMLToken {
    public MXMLToken(int tokenType, int start, int end, int line, int column, CharSequence tokenText) {
        super(tokenType, start, end, line, column, tokenText);
    }

    public MXMLToken(MXMLToken other) {
        super(other);
    }

    public MXMLToken(ASToken other) {
        super(other);
    }

    @Override
    public ICMToken changeType(int type) {
        return new MXMLToken(type, this.getStart(), this.getEnd(), this.getLine(), this.getColumn(), this.getText());
    }

    @Override
    public MXMLToken clone() {
        return new MXMLToken(this);
    }

    public final boolean isASToken() {
        return !MXMLToken.isE4X(this.type);
    }

    @Override
    public IMXMLToken.MXMLTokenKind getMXMLTokenKind() {
        switch (this.getType()) {
            case 8: {
                return IMXMLToken.MXMLTokenKind.TAG_OPEN_START;
            }
            case 3: {
                return IMXMLToken.MXMLTokenKind.TAG_CLOSE_START;
            }
            case 11: {
                return IMXMLToken.MXMLTokenKind.TAG_END;
            }
            case 5: {
                return IMXMLToken.MXMLTokenKind.EMPTY_TAG_END;
            }
            case 7: {
                return IMXMLToken.MXMLTokenKind.NAME;
            }
            case 6: {
                return IMXMLToken.MXMLTokenKind.EQUALS;
            }
            case 10: {
                return IMXMLToken.MXMLTokenKind.STRING;
            }
            case 12: {
                return IMXMLToken.MXMLTokenKind.TEXT;
            }
            case 4: {
                return IMXMLToken.MXMLTokenKind.COMMENT;
            }
            case 2: {
                return IMXMLToken.MXMLTokenKind.CDATA;
            }
            case 1: {
                return IMXMLToken.MXMLTokenKind.COMMENT;
            }
            case 13: {
                return IMXMLToken.MXMLTokenKind.WHITESPACE;
            }
        }
        if (this.isASToken()) {
            return IMXMLToken.MXMLTokenKind.ACTIONSCRIPT;
        }
        return IMXMLToken.MXMLTokenKind.UNKNOWN;
    }

    public static final boolean isTagStart(int type) {
        switch (type) {
            case 3: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public final boolean isTagStart() {
        return MXMLToken.isTagStart(this.getType());
    }

    public static final boolean isTagEnd(int type) {
        switch (type) {
            case 5: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public final boolean isTagEnd() {
        return MXMLToken.isTagEnd(this.getType());
    }

    public static final boolean isStructureTag(int type) {
        switch (type) {
            case 3: 
            case 5: 
            case 8: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public final boolean isStructureTag() {
        return MXMLToken.isStructureTag(this.getType());
    }

    public static final boolean canFollowCloseTag(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    public final boolean canFollowCloseTag() {
        return MXMLToken.canFollowCloseTag(this.getType());
    }

    @Override
    public String getTypeString() {
        switch (this.getType()) {
            case 13: {
                return "TOKEN_WHITESPACE";
            }
            case 8: {
                return "TOKEN_OPEN_TAG_START";
            }
            case 3: {
                return "TOKEN_CLOSE_TAG_START";
            }
            case 11: {
                return "TOKEN_TAG_END";
            }
            case 5: {
                return "TOKEN_EMPTY_TAG_END";
            }
            case 7: {
                return "TOKEN_NAME";
            }
            case 6: {
                return "TOKEN_EQUALS";
            }
            case 10: {
                return "TOKEN_STRING";
            }
            case 12: {
                return "TOKEN_TEXT";
            }
            case 2: {
                return "TOKEN_CDATA";
            }
            case 1: {
                return "TOKEN_ASDOC_COMMENT";
            }
            case 4: {
                return "TOKEN_COMMENT";
            }
            case 9: {
                return "TOKEN_PROCESSING_INSTRUCTION";
            }
        }
        return super.getTypeString();
    }
}

