/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.as;

import org.apache.flex.compiler.common.ASModifier;
import org.apache.flex.compiler.internal.tree.as.FixedChildrenNode;
import org.apache.flex.compiler.parsing.IASToken;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IModifierNode;

public class ModifierNode
extends FixedChildrenNode
implements IModifierNode {
    private ASModifier modifier;

    public ModifierNode(IASToken keyword) {
        if (keyword != null) {
            this.modifier = ASModifier.getASModifier(keyword.getText());
            this.span(keyword);
        }
    }

    public ModifierNode(String keyword) {
        this.modifier = ASModifier.getASModifier(keyword);
        this.setStart(-1);
        this.setEnd(-1);
    }

    @Override
    public ASTNodeID getNodeID() {
        if (this.modifier != null) {
            if (ASModifier.DYNAMIC == this.modifier) {
                return ASTNodeID.DynamicID;
            }
            if (ASModifier.FINAL == this.modifier) {
                return ASTNodeID.FinalID;
            }
            if (ASModifier.NATIVE == this.modifier) {
                return ASTNodeID.NativeID;
            }
            if (ASModifier.OVERRIDE == this.modifier) {
                return ASTNodeID.OverrideID;
            }
            if (ASModifier.STATIC == this.modifier) {
                return ASTNodeID.StaticID;
            }
        }
        return ASTNodeID.ModifierID;
    }

    @Override
    public void normalize(boolean fillInOffsets) {
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        sb.append('\"');
        sb.append(this.getModifierString());
        sb.append('\"');
        return true;
    }

    @Override
    public ASModifier getModifier() {
        return this.modifier;
    }

    @Override
    public String getModifierString() {
        return this.modifier != null ? this.modifier.toString() : "";
    }
}

