/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.mxml;

import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.internal.parsing.ISourceFragment;
import org.apache.flex.compiler.internal.projects.FlexProject;
import org.apache.flex.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.flex.compiler.internal.tree.as.NodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLExpressionNodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.flex.compiler.mxml.IMXMLTagData;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.mxml.IMXMLClassNode;

class MXMLClassNode
extends MXMLExpressionNodeBase
implements IMXMLClassNode {
    private static final Object DEFAULT = null;

    MXMLClassNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLClassID;
    }

    @Override
    public String getName() {
        return "Class";
    }

    @Override
    public ITypeDefinition getValue(ICompilerProject project) {
        IDefinition d;
        assert (this.getExpressionNode() instanceof IExpressionNode) : "getValue() shouldn't be getting called on a non-expression MXMLClassNode";
        IExpressionNode expressionNode = (IExpressionNode)this.getExpressionNode();
        if (expressionNode != null && (d = expressionNode.resolve(project)) instanceof ITypeDefinition) {
            return (ITypeDefinition)d;
        }
        return null;
    }

    @Override
    public MXMLExpressionNodeBase.ExpressionType getExpressionType() {
        return MXMLExpressionNodeBase.ExpressionType.CLASS;
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        NodeBase expressionNode = this.parseExpressionNodeFromFragments(builder, tag, info, DEFAULT);
        this.setExpressionNode(expressionNode);
        if (expressionNode instanceof MemberAccessExpressionNode) {
            ((MemberAccessExpressionNode)expressionNode).setStemAsPackage(true);
        }
        super.initializationComplete(builder, tag, info);
    }

    protected void initializeFromFragments(MXMLTreeBuilder builder, ISourceLocation location, ISourceFragment[] fragments) {
        this.setLocation(location);
        FlexProject project = builder.getProject();
        this.setClassReference(project, "Class");
        ITypeDefinition type = builder.getBuiltinType(this.getName());
        MXMLClassDefinitionNode classNode = (MXMLClassDefinitionNode)this.getClassDefinitionNode();
        NodeBase expressionNode = builder.parseExpressionNode(type, fragments, location, FLAGS, DEFAULT, classNode, true);
        this.setExpressionNode(expressionNode);
        if (expressionNode instanceof MemberAccessExpressionNode) {
            ((MemberAccessExpressionNode)expressionNode).setStemAsPackage(true);
        }
    }

    @Override
    public void initialize(MXMLTreeBuilder builder, ISourceLocation location, String type, NodeBase expressionNode) {
        super.initialize(builder, location, type, expressionNode);
        if (expressionNode instanceof MemberAccessExpressionNode) {
            ((MemberAccessExpressionNode)expressionNode).setStemAsPackage(true);
        }
    }
}

