/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.mxml;

import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.internal.parsing.SourceFragment;
import org.apache.flex.compiler.internal.tree.as.NodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLExpressionNodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLLiteralNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.flex.compiler.mxml.IMXMLTagAttributeData;
import org.apache.flex.compiler.mxml.IMXMLTagData;
import org.apache.flex.compiler.problems.MXMLDualContentProblem;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.mxml.IMXMLStringNode;

class MXMLStringNode
extends MXMLExpressionNodeBase
implements IMXMLStringNode {
    private static final String DEFAULT = null;

    MXMLStringNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLStringID;
    }

    @Override
    public String getName() {
        return "String";
    }

    @Override
    public String getValue() {
        assert (this.getExpressionNode() instanceof MXMLLiteralNode) : "getValue() shouldn't be getting called on a non-literal MXMLStringNode";
        MXMLLiteralNode literalNode = (MXMLLiteralNode)this.getExpressionNode();
        return (String)literalNode.getValue();
    }

    @Override
    public MXMLExpressionNodeBase.ExpressionType getExpressionType() {
        return MXMLExpressionNodeBase.ExpressionType.STRING;
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        if (attribute.isSpecialAttribute("source")) {
            String text;
            String sourcePath = MXMLStringNode.resolveSourceAttributePath(builder, attribute, info);
            if (sourcePath != null && (text = builder.readExternalFile(attribute, sourcePath)) != null) {
                ISourceLocation location = attribute.getValueLocation();
                SourceFragment fragment = new SourceFragment(text, text, location.getStart(), location.getLine(), location.getColumn());
                info.addSourceFragments(sourcePath, new SourceFragment[]{fragment});
            }
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializationComplete(builder, tag, info);
        if (info.hasSourceAttribute && info.hasDualContent) {
            MXMLDualContentProblem problem = new MXMLDualContentProblem(tag, tag.getShortName());
            builder.addProblem(problem);
            return;
        }
        NodeBase expressionNode = this.createExpressionNodeFromFragments(builder, tag, info, DEFAULT);
        this.setExpressionNode(expressionNode);
        super.initializationComplete(builder, tag, info);
    }
}

