/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.units.requests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.flex.abc.ABCParser;
import org.apache.flex.abc.print.ABCDumpVisitor;
import org.apache.flex.compiler.internal.embedding.EmbedData;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.units.requests.IABCBytesRequestResult;

public class ABCBytesRequestResult
implements IABCBytesRequestResult {
    private final byte[] bytes;
    private final ICompilerProblem[] problems;
    private final Set<EmbedData> embeds;

    public ABCBytesRequestResult(byte[] bytes, ICompilerProblem[] problems, Set<EmbedData> embeds) {
        assert (bytes != null || problems != null);
        this.bytes = bytes;
        this.problems = problems;
        this.embeds = embeds;
    }

    public ABCBytesRequestResult(byte[] bytes) {
        assert (bytes != null);
        this.bytes = bytes;
        this.problems = ZEROPROBLEMS;
        this.embeds = Collections.emptySet();
    }

    public ABCBytesRequestResult(ICompilerProblem[] problems) {
        assert (problems != null);
        this.bytes = ZEROBYTES;
        this.problems = problems;
        this.embeds = Collections.emptySet();
    }

    public ABCBytesRequestResult() {
        this.bytes = ZEROBYTES;
        this.problems = ZEROPROBLEMS;
        this.embeds = Collections.emptySet();
    }

    @Override
    public byte[] getABCBytes() {
        return this.bytes;
    }

    @Override
    public ICompilerProblem[] getProblems() {
        return this.problems;
    }

    @Override
    public Collection<EmbedData> getEmbeds() {
        return this.embeds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        PrintWriter out = new PrintWriter((Writer)new StringBuilderWriter(sb));
        ABCParser parser = null;
        try {
            parser = new ABCParser(new ByteArrayInputStream(this.bytes));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        parser.parseABC(new ABCDumpVisitor(out, false));
        return sb.toString();
    }
}

