/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.units.requests;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flex.compiler.internal.workspaces.Workspace;
import org.apache.flex.compiler.units.requests.IRequest;
import org.apache.flex.compiler.units.requests.IRequestResult;

public abstract class RequestMaker<ResultType extends IRequestResult, RequesteeInterfaceType, RequesteeType extends RequesteeInterfaceType> {
    private static final boolean THROW_ASSERTIONS = System.getProperty("throw.assertions", "false").equals("true");

    public final IRequest<ResultType, RequesteeInterfaceType> getRequest(RequesteeType u, AtomicReference<IRequest<ResultType, RequesteeInterfaceType>> atomicRef, Workspace workspace, boolean isNeededForFileScope) {
        IRequest<ResultType, RequesteeInterfaceType> existingRequest = atomicRef.get();
        if (existingRequest == null) {
            workspace.startRequest(isNeededForFileScope);
            Request request = new Request(u);
            if (atomicRef.compareAndSet(null, request)) {
                ExecutorService exec = workspace.getExecutorService();
                request.setFuture(exec.submit(this.wrapCallable(u, this.getCallable(u), workspace)));
            } else {
                workspace.endRequest();
            }
            assert (atomicRef.get() != null);
            return atomicRef.get();
        }
        return existingRequest;
    }

    private Callable<ResultType> wrapCallable(final RequesteeType u, final Callable<ResultType> c, final Workspace workspace) {
        return new Callable<ResultType>(){

            @Override
            public ResultType call() throws InterruptedException {
                try {
                    IRequestResult iRequestResult = (IRequestResult)c.call();
                    return iRequestResult;
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (AssertionError ae) {
                    if (THROW_ASSERTIONS) {
                        throw ae;
                    }
                    Object ResultType = RequestMaker.this.getResultForThrowable(u, (Throwable)((Object)ae));
                    return ResultType;
                }
                catch (Exception e) {
                    Object ResultType = RequestMaker.this.getResultForThrowable(u, e);
                    return ResultType;
                }
                finally {
                    workspace.endRequest();
                }
            }
        };
    }

    protected abstract Callable<ResultType> getCallable(RequesteeType var1);

    protected abstract ResultType getResultForThrowable(RequesteeType var1, Throwable var2);

    private static class Request<V extends IRequestResult, W>
    implements IRequest<V, W> {
        private Future<V> future;
        private Lock lock = new ReentrantLock();
        private Condition haveFuture = this.lock.newCondition();
        private final long timestamp = System.currentTimeMillis();
        private final W requestee;

        public Request(W requestee) {
            this.requestee = requestee;
        }

        @Override
        public V get() throws InterruptedException {
            IRequestResult result = null;
            try {
                result = (IRequestResult)this.getFuture().get();
            }
            catch (ExecutionException executionException) {
                Throwable cause = executionException.getCause();
                if (THROW_ASSERTIONS && cause instanceof AssertionError) {
                    throw (AssertionError)((Object)cause);
                }
                assert (false) : "Unexpected ExecutionException!";
                executionException.printStackTrace();
            }
            return (V)result;
        }

        @Override
        public boolean isDone() {
            this.lock.lock();
            try {
                if (this.future == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.future.isDone();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        private Future<V> getFuture() {
            this.lock.lock();
            try {
                while (this.future == null) {
                    this.haveFuture.awaitUninterruptibly();
                }
                Future<V> future = this.future;
                return future;
            }
            finally {
                this.lock.unlock();
            }
        }

        private void setFuture(Future<V> future) {
            this.lock.lock();
            try {
                this.future = future;
                this.haveFuture.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public long getTimeStamp() {
            return this.timestamp;
        }

        @Override
        public W getRequestee() {
            return this.requestee;
        }
    }
}

