/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.swf.io;

import SevenZip.Compression.LZMA.Encoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flex.swf.io.IOutputBitStream;
import org.apache.flex.utils.DAByteArrayOutputStream;

public class LZMACompressor {
    private DAByteArrayOutputStream byteArrayOutputStream = null;
    private final Encoder encoder = new Encoder();

    public LZMACompressor() {
        if (!this.encoder.SetAlgorithm(1)) assert (false);
        int dictionarySize = 0x200000;
        if (!this.encoder.SetDictionarySize(dictionarySize)) assert (false);
        if (!this.encoder.SetNumFastBytes(128)) assert (false);
        if (!this.encoder.SetMatchFinder(1)) assert (false);
        int lc = 3;
        int lp = 0;
        int pb = 2;
        if (!this.encoder.SetLcLpPb(lc, lp, pb)) assert (false);
        this.encoder.SetEndMarkerMode(true);
    }

    public void compress(IOutputBitStream outputBitStream) throws IOException {
        assert (this.byteArrayOutputStream == null);
        this.byteArrayOutputStream = new DAByteArrayOutputStream();
        StreamAdapter is = new StreamAdapter(outputBitStream);
        this.encoder.Code((InputStream)is, (OutputStream)this.byteArrayOutputStream, -1L, -1L, null);
    }

    public void writeLZMAProperties(OutputStream outputStream) throws IOException {
        this.encoder.WriteCoderProperties(outputStream);
    }

    public void writeDataAndEnd(OutputStream outputStream) throws IOException {
        byte[] data = this.byteArrayOutputStream.getDirectByteArray();
        outputStream.write(data, 0, data.length);
        outputStream.flush();
    }

    public long getLengthOfCompressedPayload() {
        assert (this.byteArrayOutputStream != null);
        return this.byteArrayOutputStream.size();
    }

    public static class StreamAdapter
    extends InputStream {
        private final byte[] bytes;
        private final long totalByteCount;
        private int position = 0;

        public StreamAdapter(IOutputBitStream outputBitStream) {
            this.bytes = outputBitStream.getBytes();
            this.totalByteCount = outputBitStream.size();
        }

        @Override
        public int read() throws IOException {
            int ret = -1;
            if ((long)this.position >= this.totalByteCount) {
                ret = -1;
            } else if ((ret = this.bytes[this.position++]) < 0) {
                ret += 256;
            }
            return ret;
        }

        long getCount() {
            return this.totalByteCount;
        }
    }
}

