/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import java.util.Arrays;
import java.util.Map;

public class MapSubject<S extends MapSubject<S, K, V, M>, K, V, M extends Map<K, V>>
extends Subject<S, M> {
    private MapSubject(FailureStrategy failureStrategy, M map) {
        super(failureStrategy, map);
    }

    static <K, V, M extends Map<K, V>> MapSubject<? extends MapSubject<?, K, V, M>, K, V, M> create(FailureStrategy failureStrategy, Map<K, V> map) {
        return new MapSubject(failureStrategy, map);
    }

    public void isEmpty() {
        if (!((Map)this.getSubject()).isEmpty()) {
            this.fail("is empty");
        }
    }

    public void isNotEmpty() {
        if (((Map)this.getSubject()).isEmpty()) {
            this.fail("is not empty");
        }
    }

    public final void hasSize(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (String)"expectedSize(%s) must be >= 0", (Object[])new Object[]{expectedSize});
        int actualSize = ((Map)this.getSubject()).size();
        if (actualSize != expectedSize) {
            this.failWithBadResults("has a size of", expectedSize, "is", actualSize);
        }
    }

    public void containsKey(Object key) {
        if (!((Map)this.getSubject()).containsKey(key)) {
            this.fail("contains key", key);
        }
    }

    public void doesNotContainKey(Object key) {
        if (((Map)this.getSubject()).containsKey(key)) {
            this.fail("does not contain key", key);
        }
    }

    public void containsEntry(Object key, Object value) {
        Map.Entry entry = Maps.immutableEntry((Object)key, (Object)value);
        if (!((Map)this.getSubject()).entrySet().contains(entry)) {
            this.fail("contains entry", (Object)entry);
        }
    }

    public void doesNotContainEntry(Object key, Object value) {
        Map.Entry entry = Maps.immutableEntry((Object)key, (Object)value);
        if (((Map)this.getSubject()).entrySet().contains(entry)) {
            this.fail("does not contain entry", (Object)entry);
        }
    }

    @Deprecated
    public WithValue<V> hasKey(final K key) {
        if (!((Map)this.getSubject()).containsKey(key)) {
            this.fail("has key", (Object)key);
        }
        return new WithValue<V>(){

            @Override
            public void withValue(V expected) {
                Object actual = ((Map)MapSubject.this.getSubject()).get(key);
                if (actual == null && expected != null || actual != expected && !actual.equals(expected)) {
                    MapSubject.this.fail("has key/value pair", Arrays.asList(key, expected), "actually has key/value pair", Arrays.asList(key, actual));
                }
            }
        };
    }

    @Deprecated
    public void lacksKey(K key) {
        if (((Map)this.getSubject()).containsKey(key)) {
            this.fail("lacks key", (Object)key);
        }
    }

    @Deprecated
    public static interface WithValue<V> {
        @Deprecated
        public void withValue(V var1);
    }
}

