/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.as;

import org.apache.flex.compiler.codegen.as.IASEmitter;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IContainerNode;
import org.apache.flex.compiler.visitor.IASNodeStrategy;

public class ASBeforeNodeStrategy
implements IASNodeStrategy {
    private final IASEmitter emitter;

    public ASBeforeNodeStrategy(IASEmitter emitter) {
        this.emitter = emitter;
    }

    @Override
    public void handle(IASNode node) {
        if (node.getNodeID() == ASTNodeID.BlockID) {
            IASNode parent = node.getParent();
            IContainerNode container = (IContainerNode)node;
            IContainerNode.ContainerType type = container.getContainerType();
            if (parent.getNodeID() != ASTNodeID.LabledStatementID && node.getChildCount() != 0) {
                this.emitter.indentPush();
            }
            if (type != IContainerNode.ContainerType.IMPLICIT && type != IContainerNode.ContainerType.SYNTHESIZED) {
                this.emitter.emitBlockOpen(container);
            }
            if (parent.getNodeID() != ASTNodeID.LabledStatementID) {
                this.emitter.writeNewline();
            }
        }
    }
}

