/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.mxml.flexjs;

import com.google.javascript.jscomp.SourceFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.flex.compiler.clients.problems.ProblemQuery;
import org.apache.flex.compiler.codegen.js.IJSPublisher;
import org.apache.flex.compiler.config.Configuration;
import org.apache.flex.compiler.css.ICSSPropertyValue;
import org.apache.flex.compiler.internal.codegen.js.goog.JSGoogPublisher;
import org.apache.flex.compiler.internal.codegen.js.goog.JarSourceFile;
import org.apache.flex.compiler.internal.css.CSSArrayPropertyValue;
import org.apache.flex.compiler.internal.css.CSSFontFace;
import org.apache.flex.compiler.internal.css.CSSFunctionCallPropertyValue;
import org.apache.flex.compiler.internal.driver.js.flexjs.JSCSSCompilationSession;
import org.apache.flex.compiler.internal.driver.js.goog.JSGoogConfiguration;
import org.apache.flex.compiler.internal.graph.GoogDepsWriter;
import org.apache.flex.compiler.internal.projects.CompilerProject;
import org.apache.flex.compiler.internal.projects.FlexJSProject;
import org.apache.flex.compiler.internal.targets.ITargetAttributes;
import org.apache.flex.compiler.utils.JSClosureCompilerWrapper;
import org.apache.flex.swc.ISWC;
import org.apache.flex.swc.ISWCFileEntry;

public class MXMLFlexJSPublisher
extends JSGoogPublisher
implements IJSPublisher {
    public static final String FLEXJS_OUTPUT_DIR_NAME = "bin";
    public static final String FLEXJS_INTERMEDIATE_DIR_NAME = "js-debug";
    public static final String FLEXJS_RELEASE_DIR_NAME = "js-release";
    private static final String FLEXJS_EXTERNS = "externs";
    protected FlexJSProject project;
    private boolean isMarmotinniRun;
    private String outputPathParameter;
    private boolean useStrictPublishing;

    public MXMLFlexJSPublisher(FlexJSProject project, Configuration config) {
        super(project, config);
        this.isMarmotinniRun = this.googConfiguration.getMarmotinni() != null;
        this.outputPathParameter = this.configuration.getOutput();
        this.useStrictPublishing = this.googConfiguration.getStrictPublish();
        this.project = project;
    }

    private GoogDepsWriter getGoogDepsWriter(File intermediateDir, String projectName, JSGoogConfiguration googConfiguration, List<ISWC> swcs) {
        return new GoogDepsWriter(intermediateDir, projectName, googConfiguration, swcs);
    }

    @Override
    public File getOutputFolder() {
        if (this.isMarmotinniRun) {
            this.outputParentFolder = new File(this.googConfiguration.getMarmotinni());
        } else if (this.outputPathParameter != null) {
            if (this.outputPathParameter.contains(".swf")) {
                if (this.outputParentFolder == null) {
                    this.outputParentFolder = new File(this.outputPathParameter);
                }
                this.outputParentFolder = this.outputParentFolder.getParentFile().getParentFile();
            } else {
                this.outputParentFolder = new File(this.outputPathParameter);
            }
        } else {
            String mainClassFolder = this.configuration.getTargetFileDirectory();
            this.outputParentFolder = mainClassFolder.endsWith("src") ? new File(this.configuration.getTargetFileDirectory()).getParentFile() : (mainClassFolder.endsWith("src/main/flex") || mainClassFolder.endsWith("src\\main\\flex") ? new File(this.configuration.getTargetFileDirectory()).getParentFile().getParentFile().getParentFile() : new File(this.configuration.getTargetFileDirectory()));
        }
        this.outputParentFolder = new File(this.outputParentFolder, FLEXJS_OUTPUT_DIR_NAME);
        this.outputFolder = new File(this.outputParentFolder, File.separator + FLEXJS_INTERMEDIATE_DIR_NAME);
        if (!this.isMarmotinniRun && !this.googConfiguration.getSkipTranspile()) {
            this.setupOutputFolder();
        }
        return this.outputFolder;
    }

    @Override
    public boolean publish(ProblemQuery problems) throws IOException {
        File closureLibraryJar;
        File intermediateDir = this.outputFolder;
        String projectName = FilenameUtils.getBaseName((String)this.configuration.getTargetFile());
        String outputFileName = projectName + "." + this.project.getBackend().getOutputExtension();
        File releaseDir = new File(this.outputParentFolder, FLEXJS_RELEASE_DIR_NAME);
        IOFileFilter pngSuffixFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, FileFilterUtils.suffixFileFilter((String)".png")});
        IOFileFilter gifSuffixFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, FileFilterUtils.suffixFileFilter((String)".gif")});
        IOFileFilter jpgSuffixFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, FileFilterUtils.suffixFileFilter((String)".jpg")});
        IOFileFilter jpegSuffixFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, FileFilterUtils.suffixFileFilter((String)".jpeg")});
        IOFileFilter svgSuffixFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, FileFilterUtils.suffixFileFilter((String)".svg")});
        IOFileFilter jsonSuffixFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, FileFilterUtils.suffixFileFilter((String)".json")});
        IOFileFilter assetFiles = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{pngSuffixFilter, jpgSuffixFilter, jpegSuffixFilter, svgSuffixFilter, gifSuffixFilter, jsonSuffixFilter});
        IOFileFilter resourceFilter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{DirectoryFileFilter.DIRECTORY, assetFiles});
        File imageSrcDir = new File(this.configuration.getTargetFile()).getAbsoluteFile().getParentFile();
        FileUtils.copyDirectory((File)imageSrcDir, (File)intermediateDir, (FileFilter)resourceFilter);
        if (this.configuration.release()) {
            FileUtils.copyDirectory((File)imageSrcDir, (File)releaseDir, (FileFilter)resourceFilter);
            this.clearEmptyDirectoryTrees(releaseDir);
        }
        List<SourceFile> closureSourceFiles = null;
        if (!this.googConfiguration.isClosureLibSet() && (closureLibraryJar = this.getJarThatContainsClasspathResources("goog/deps.js")) != null) {
            Properties whiteList = new Properties();
            whiteList.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("flexjs/closure-whitelist.properites"));
            closureSourceFiles = this.getClasspathResources(closureLibraryJar, whiteList);
        }
        if (closureSourceFiles == null) {
            File closureLibDir = new File(this.googConfiguration.getClosureLib());
            if (!closureLibDir.exists() || !closureLibDir.isDirectory()) {
                if (this.googConfiguration.isClosureLibSet()) {
                    throw new RuntimeException("Parameter 'closure-lib' doesn't point to a valid directory.");
                }
            } else {
                closureSourceFiles = this.getDirectoryResources(new File(closureLibDir, "closure"));
            }
        }
        if (closureSourceFiles == null || closureSourceFiles.size() == 0) {
            throw new RuntimeException("Parameter 'closure-lib' not specified and closure resources not available in classpath.");
        }
        for (SourceFile closureSourceFile : closureSourceFiles) {
            FileUtils.write((File)new File(new File(intermediateDir, "library/closure"), closureSourceFile.getName()), (CharSequence)closureSourceFile.getCode());
        }
        closureSourceFiles = this.closureFilesInOrder(intermediateDir + "/library/closure/", closureSourceFiles, "goog.events.EventTarget");
        File projectIntermediateMainFile = new File(intermediateDir, outputFileName);
        JSClosureCompilerWrapper compilerWrapper = new JSClosureCompilerWrapper(this.googConfiguration.getJSCompilerOptions());
        for (SourceFile sourceFile : closureSourceFiles) {
            compilerWrapper.addJSSourceFile(sourceFile);
        }
        List swcs = this.project.getLibraries();
        for (ISWC swc : swcs) {
            Map files = swc.getFiles();
            for (String key : files.keySet()) {
                ISWCFileEntry fileEntry;
                if (!key.startsWith(FLEXJS_EXTERNS) || (fileEntry = swc.getFile(key)) == null) continue;
                InputStream is = fileEntry.createInputStream();
                String code = IOUtils.toString((InputStream)is, (String)"UTF-8");
                is.close();
                JarSourceFile externFile = new JarSourceFile(key, code, true);
                System.out.println("using extern: " + key);
                compilerWrapper.addJSExternsFile(externFile);
            }
        }
        GoogDepsWriter googDepsWriter = this.getGoogDepsWriter(intermediateDir, projectName, this.googConfiguration, swcs);
        ArrayList<String> fileList = googDepsWriter.getListOfFiles((CompilerProject)this.project, problems);
        for (String file : fileList) {
            compilerWrapper.addJSSourceFile(file);
        }
        String depsFileData = googDepsWriter.generateDeps((CompilerProject)this.project, problems);
        File template = ((JSGoogConfiguration)this.configuration).getHtmlTemplate();
        if (!((JSGoogConfiguration)this.configuration).getSkipTranspile()) {
            if (template != null) {
                this.writeTemplate(template, "intermediate", projectName, intermediateDir, depsFileData, googDepsWriter.additionalHTML);
            } else {
                this.writeHTML("intermediate", projectName, intermediateDir, depsFileData, googDepsWriter.additionalHTML);
            }
        }
        if (this.configuration.release()) {
            if (template != null) {
                this.writeTemplate(template, "release", projectName, releaseDir, depsFileData, googDepsWriter.additionalHTML);
            } else {
                this.writeHTML("release", projectName, releaseDir, null, googDepsWriter.additionalHTML);
            }
        }
        this.project.needCSS = googDepsWriter.needCSS;
        if (this.project.needCSS || this.googConfiguration.getSkipTranspile()) {
            if (!this.googConfiguration.getSkipTranspile()) {
                this.writeCSS(projectName, intermediateDir);
            }
            if (this.project.needCSS && this.configuration.release()) {
                FileUtils.copyFile((File)new File(intermediateDir, projectName + ".css"), (File)new File(releaseDir, projectName + ".css"));
            }
        }
        if (this.configuration.release()) {
            File projectReleaseMainFile = new File(releaseDir, outputFileName);
            compilerWrapper.setOptions(projectReleaseMainFile.getCanonicalPath(), this.useStrictPublishing, !this.googConfiguration.getRemoveCirculars(), projectName);
            compilerWrapper.targetFilePath = projectReleaseMainFile.getCanonicalPath();
            compilerWrapper.compile();
            this.appendSourceMapLocation(projectReleaseMainFile, projectName);
        }
        System.out.println("The project '" + projectName + "' has been successfully compiled and optimized.");
        return true;
    }

    protected List<SourceFile> closureFilesInOrder(String path, List<SourceFile> files, String entryPoint) {
        ArrayList<String> sortedFiles = new ArrayList<String>();
        HashMap<String, SourceFile> fileMap = new HashMap<String, SourceFile>();
        SourceFile depsFile = null;
        for (SourceFile sourceFile : files) {
            if ((sourceFile.getOriginalPath().endsWith("goog/deps.js") || sourceFile.getOriginalPath().endsWith("goog\\deps.js")) && !sourceFile.getOriginalPath().endsWith("third_party/goog/deps.js") && !sourceFile.getOriginalPath().endsWith("third_party\\goog\\deps.js")) {
                depsFile = sourceFile;
            }
            System.out.println("originalPath: " + sourceFile.getOriginalPath());
            fileMap.put(sourceFile.getOriginalPath(), sourceFile);
        }
        ArrayList<String> deps = new ArrayList<String>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path + depsFile.getOriginalPath()), "UTF8"));
            while (true) {
                String line;
                if ((line = in.readLine()).startsWith("//") || line.trim().length() == 0) {
                    continue;
                }
                deps.add(line);
            }
        }
        catch (Exception in) {
            this.sortClosureFile(deps, entryPoint, sortedFiles);
            ArrayList<SourceFile> list = new ArrayList<SourceFile>();
            ArrayList<String> seen = new ArrayList<String>();
            sortedFiles.add("deps.js");
            sortedFiles.add("base.js");
            sortedFiles.add("bootstrap/nodejs.js");
            int n = sortedFiles.size();
            for (int i = n - 1; i >= 0; --i) {
                String fileName = sortedFiles.get(i);
                System.out.println("sorted filename: " + fileName);
                if (seen.contains(fileName)) continue;
                seen.add(fileName);
                list.add((SourceFile)fileMap.get("goog/" + fileName));
            }
            return list;
        }
    }

    private void sortClosureFile(List<String> deps, String entryPoint, List<String> sortedFiles) {
        String provided = this.getProvidedFile(deps, entryPoint);
        sortedFiles.add(provided);
        List<String> reqs = this.getRequires(deps, entryPoint);
        if (reqs == null) {
            return;
        }
        for (String req : reqs) {
            this.sortClosureFile(deps, req, sortedFiles);
        }
    }

    private String getProvidedFile(List<String> deps, String name) {
        for (String dep : deps) {
            int open = dep.indexOf("[");
            int close = dep.indexOf("]");
            String list = dep.substring(open + 1, close);
            String[] parts = list.split(",");
            ArrayList<String> provideds = new ArrayList<String>();
            for (String part : parts) {
                if ((part = part.trim()).startsWith("'")) {
                    part = part.substring(1, part.length() - 1);
                }
                provideds.add(part);
            }
            if (!provideds.contains(name)) continue;
            open = dep.indexOf("'");
            close = dep.indexOf("'", open + 1);
            return dep.substring(open + 1, close);
        }
        return null;
    }

    private List<String> getRequires(List<String> deps, String name) {
        for (String dep : deps) {
            int open = dep.indexOf("[");
            int close = dep.indexOf("]");
            String list = dep.substring(open + 1, close);
            String[] parts = list.split(",");
            ArrayList<String> provideds = new ArrayList<String>();
            for (String part : parts) {
                if ((part = part.trim()).startsWith("'")) {
                    part = part.substring(1, part.length() - 1);
                }
                provideds.add(part);
            }
            if (!provideds.contains(name)) continue;
            open = dep.indexOf("[", close + 1);
            if (open + 1 == (close = dep.indexOf("]", open + 1))) {
                return null;
            }
            String list2 = dep.substring(open + 1, close);
            String[] parts2 = list2.split(",");
            ArrayList<String> reqs = new ArrayList<String>();
            for (String part : parts2) {
                if ((part = part.trim()).startsWith("'")) {
                    part = part.substring(1, part.length() - 1);
                }
                reqs.add(part);
            }
            return reqs;
        }
        return null;
    }

    protected String readCode(File file) {
        String code = "";
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            String line = in.readLine();
            while (line != null) {
                code = code + line + "\n";
                line = in.readLine();
            }
            code = code.substring(0, code.length() - 1);
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code;
    }

    protected void writeTemplate(File template, String type, String projectName, File targetDir, String deps, List<String> additionalHTML) throws IOException {
        if (!template.exists()) {
            throw new IOException("Template specified by 'html-template' does not exist: " + template.getPath());
        }
        String input = this.readCode(template);
        ITargetAttributes ta = this.project.computeTargetAttributes();
        Float width = null;
        Float height = null;
        String bgcolor = null;
        String pageTitle = null;
        if (ta != null) {
            width = ta.getWidth();
            height = ta.getHeight();
            bgcolor = ta.getBackgroundColor();
            pageTitle = ta.getPageTitle();
        }
        String result = input.replaceAll("\\$\\{application\\}", projectName);
        if (bgcolor != null) {
            result = result.replaceAll("\\$\\{bgcolor\\}", bgcolor);
        }
        if (height != null) {
            result = result.replaceAll("\\$\\{height\\}", height.toString());
        }
        if (pageTitle != null) {
            result = result.replaceAll("\\$\\{title\\}", pageTitle);
        }
        if (width != null) {
            result = result.replaceAll("\\$\\{width\\}", width.toString());
        }
        StringBuilder addHTML = new StringBuilder();
        addHTML.append(this.getTemplateAdditionalHTML(additionalHTML));
        addHTML.append(this.getTemplateDependencies(type, projectName, deps));
        result = result.replaceAll("\\$\\{head\\}", addHTML.toString());
        String templateBody = this.getTemplateBody(projectName);
        result = result.replaceAll("\\$\\{body\\}", templateBody);
        this.writeFile(new File(targetDir, this.googConfiguration.getHtmlOutputFileName()), result, false);
    }

    protected String getTemplateAdditionalHTML(List<String> additionalHTML) {
        StringBuilder htmlFile = new StringBuilder();
        for (String s : additionalHTML) {
            htmlFile.append(s).append("\n");
        }
        return htmlFile.toString();
    }

    protected String getTemplateDependencies(String type, String projectName, String deps) {
        StringBuilder depsHTML = new StringBuilder();
        if ("intermediate".equals(type)) {
            depsHTML.append("\t<script type=\"text/javascript\" src=\"./library/closure/goog/base.js\"></script>\n");
            depsHTML.append("\t<script type=\"text/javascript\">\n");
            depsHTML.append(deps);
            depsHTML.append("\t\tgoog.require(\"");
            depsHTML.append(projectName);
            depsHTML.append("\");\n");
            depsHTML.append("\t</script>\n");
        } else {
            depsHTML.append("\t<script type=\"text/javascript\" src=\"./");
            depsHTML.append(projectName);
            depsHTML.append(".js\"></script>\n");
        }
        return depsHTML.toString();
    }

    protected String getTemplateBody(String projectName) {
        StringBuilder bodyHTML = new StringBuilder();
        bodyHTML.append("\t<script type=\"text/javascript\">\n");
        bodyHTML.append("\t\tnew ");
        bodyHTML.append(projectName);
        bodyHTML.append("()");
        bodyHTML.append(".start();\n");
        bodyHTML.append("\t</script>\n");
        return bodyHTML.toString();
    }

    protected void writeHTML(String type, String projectName, File targetDir, String deps, List<String> additionalHTML) throws IOException {
        StringBuilder htmlFile = new StringBuilder();
        htmlFile.append("<!DOCTYPE html>\n");
        htmlFile.append("<html>\n");
        htmlFile.append("<head>\n");
        htmlFile.append("\t<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge,chrome=1\">\n");
        htmlFile.append("\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
        htmlFile.append("\t<link rel=\"stylesheet\" type=\"text/css\" href=\"").append(projectName).append(".css\">\n");
        htmlFile.append(this.getTemplateAdditionalHTML(additionalHTML));
        htmlFile.append(this.getTemplateDependencies(type, projectName, deps));
        htmlFile.append("</head>\n");
        htmlFile.append("<body>\n");
        htmlFile.append(this.getTemplateBody(projectName));
        htmlFile.append("</body>\n");
        htmlFile.append("</html>");
        this.writeFile(new File(targetDir, this.googConfiguration.getHtmlOutputFileName()), htmlFile.toString(), false);
    }

    private void writeCSS(String projectName, File targetDir) throws IOException {
        JSCSSCompilationSession cssSession = (JSCSSCompilationSession)this.project.getCSSCompilationSession();
        this.writeFile(new File(targetDir, projectName + ".css"), cssSession.emitCSS(), false);
        for (CSSFontFace fontFace : cssSession.fontFaces) {
            String configdir = this.configuration.getLoadConfig();
            File dir = new File(configdir);
            dir = dir.getParentFile();
            for (ICSSPropertyValue prop : fontFace.getSources()) {
                if (prop instanceof CSSArrayPropertyValue) {
                    for (ICSSPropertyValue value : ((CSSArrayPropertyValue)prop).getElements()) {
                        this.copyFontFile((CSSFunctionCallPropertyValue)value, dir, targetDir);
                    }
                    continue;
                }
                if (!(prop instanceof CSSFunctionCallPropertyValue)) continue;
                this.copyFontFile((CSSFunctionCallPropertyValue)prop, dir, targetDir);
            }
        }
    }

    protected void copyFontFile(CSSFunctionCallPropertyValue fn, File sourceDir, File targetDir) throws IOException {
        int c;
        String fontPath = fn.rawArguments;
        if (fontPath.startsWith("'")) {
            fontPath = fontPath.substring(1, fontPath.length() - 1);
        }
        if (fontPath.startsWith("\"")) {
            fontPath = fontPath.substring(1, fontPath.length() - 1);
        }
        if ((c = fontPath.indexOf("?")) != -1) {
            fontPath = fontPath.substring(0, c);
        }
        File fontFile = new File(sourceDir, fontPath);
        File destFile = new File(targetDir, fontPath);
        if (fontFile.exists() && !destFile.exists()) {
            FileUtils.copyFile((File)fontFile, (File)destFile);
        }
    }

    protected File getJarThatContainsClasspathResources(String resourcePath) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(resourcePath);
        if (resource != null) {
            String resourceJarPath = resource.getFile();
            try {
                resourceJarPath = URLDecoder.decode(resourceJarPath, "UTF-8");
                if (resourceJarPath.contains(":")) {
                    resourceJarPath = resourceJarPath.substring(resourceJarPath.indexOf(":") + 1);
                }
                if (resourceJarPath.contains("!")) {
                    resourceJarPath = resourceJarPath.substring(0, resourceJarPath.indexOf("!"));
                }
                return new File(resourceJarPath);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    protected void setupOutputFolder() {
        File releaseDir;
        super.setupOutputFolder();
        if (this.configuration.release() && !(releaseDir = new File(this.outputParentFolder, FLEXJS_RELEASE_DIR_NAME)).exists() && !releaseDir.mkdirs()) {
            throw new RuntimeException("Unable to create release directory at " + releaseDir.getAbsolutePath());
        }
    }

    protected void clearEmptyDirectoryTrees(File baseDirectory) {
        File[] files = baseDirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                this.clearEmptyDirectoryTrees(file);
                if (!this.isEmptyDirectory(file)) continue;
                file.delete();
            }
        }
    }

    protected boolean isEmptyDirectory(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                return false;
            }
        }
        return true;
    }

    class DependencyLineComparator
    implements Comparator<DependencyRecord> {
        DependencyLineComparator() {
        }

        @Override
        public int compare(DependencyRecord o1, DependencyRecord o2) {
            return new Integer(o1.lineNumber).compareTo(o2.lineNumber);
        }
    }

    class DependencyRecord {
        String path;
        String deps;
        String line;
        int lineNumber;

        DependencyRecord() {
        }
    }
}

