/*
 * Decompiled with CFR 0.152.
 */
package org.flexunit.ant.tasks;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.URLResource;
import org.apache.tools.ant.util.ResourceUtils;
import org.flexunit.ant.LoggingUtil;
import org.flexunit.ant.tasks.configuration.CompilationConfiguration;

public class Compilation {
    private final String FLEX_APPLICATION_CLASS = "Application";
    private final String AIR_APPLICATION_CLASS = "WindowedApplication";
    private final String MXML2006_PREFIX = "mx";
    private final String MXML2006_NAMESPACE = "xmlns:mx=\"http://www.adobe.com/2006/mxml\"";
    private final String MXML2009_PREFIX = "fx";
    private final String MXML2009_NAMESPACE = "xmlns:fx=\"http://ns.adobe.com/mxml/2009\"";
    private final String SPARK_PREFIX = "s";
    private final String SPARK_NAMESPACE = "xmlns:s=\"library://ns.adobe.com/flex/spark\"";
    private final String CI_LISTENER = "CIListener";
    private final String AIR_CI_LISTENER = "AirCIListener";
    private final String TESTRUNNER_TEMPLATE = "TestRunner.template";
    private final String TESTRUNNER_FILE = "TestRunner.mxml";
    private final String MXMLC_RELATIVE_PATH = "lib/mxmlc.jar";
    private final String FRAMEWORKS_RELATIVE_PATH = "frameworks";
    private final String SWF_FILENAME = "TestRunner.swf";
    private CompilationConfiguration configuration;
    private Project project;
    private String mxmlcPath;

    public Compilation(Project project, CompilationConfiguration compilationConfiguration) {
        this.project = project;
        this.configuration = compilationConfiguration;
        this.mxmlcPath = compilationConfiguration.getFlexHome().getAbsolutePath() + File.separatorChar + "lib/mxmlc.jar";
    }

    public File compile() throws BuildException {
        this.configuration.log();
        File file = this.generateTestRunnerFromTemplate(this.configuration.getWorkingDir());
        File file2 = new File(this.configuration.getWorkingDir().getAbsolutePath() + File.separatorChar + "TestRunner.swf");
        Java java = this.createJavaTask(file, file2);
        LoggingUtil.log("Compiling test classes: [" + this.configuration.getTestSources().getCanonicalClasses(", ") + "]", true);
        LoggingUtil.log(java.getCommandLine().describeCommand());
        if (java.executeJava() != 0) {
            throw new BuildException("Compilation failed:\n" + this.project.getProperty("MXMLC_ERROR"));
        }
        return file2;
    }

    private File generateTestRunnerFromTemplate(File file) throws BuildException {
        try {
            int n = this.getSDKVersion();
            String string = n == 3 ? "mx" : "s";
            String string2 = this.configuration.getPlayer().equals("flash") ? "Application" : "WindowedApplication";
            String string3 = n == 3 ? "mx" : "fx";
            String string4 = n == 3 ? "xmlns:mx=\"http://www.adobe.com/2006/mxml\"" : "xmlns:fx=\"http://ns.adobe.com/mxml/2009\"\nxmlns:s=\"library://ns.adobe.com/flex/spark\"";
            String string5 = this.configuration.getPlayer().equals("flash") ? "CIListener" : "AirCIListener";
            File file2 = new File(file.getAbsolutePath() + File.separatorChar + "TestRunner.mxml");
            URLResource uRLResource = new URLResource(this.getClass().getResource("/TestRunner.template"));
            FilterSet filterSet = new FilterSet();
            filterSet.addFilter("APPLICATION_PREFIX", string);
            filterSet.addFilter("APPLICATION_CLASS", string2);
            filterSet.addFilter("NAMESPACES", string4);
            filterSet.addFilter("MXML_PREFIX", string3);
            filterSet.addFilter("CI_LISTENER_CLASS", string5);
            filterSet.addFilter("CLASS_REFS", this.configuration.getTestSources().getClasses());
            filterSet.addFilter("IMPORT_REFS", this.configuration.getTestSources().getImports());
            ResourceUtils.copyResource((Resource)uRLResource, (Resource)new FileResource(file2), (FilterSetCollection)new FilterSetCollection(filterSet), null, (boolean)true, (boolean)false, null, null, (Project)this.project);
            LoggingUtil.log("Created test runner at [" + file2.getAbsolutePath() + "]");
            return file2;
        }
        catch (Exception exception) {
            throw new BuildException("Could not create test runner from template.", (Throwable)exception);
        }
    }

    private int getSDKVersion() {
        String string = "SDK_VERSION";
        Java java = new Java();
        java.setFork(true);
        java.setFailonerror(true);
        java.setJar(new File(this.mxmlcPath));
        java.setProject(this.project);
        java.setDir(this.project.getBaseDir());
        java.setOutputproperty(string);
        Commandline.Argument argument = java.createArg();
        argument.setValue("--version");
        java.execute();
        String string2 = this.project.getProperty(string);
        int n = string2.indexOf("Version ");
        int n2 = Integer.parseInt(string2.substring(n + 8, n + 9));
        LoggingUtil.log("Found SDK version: " + n2);
        return n2;
    }

    private Java createJavaTask(File file, File file2) {
        Commandline.Argument argument;
        String string = this.configuration.getFlexHome().getAbsolutePath() + File.separatorChar + "frameworks";
        Java java = new Java();
        java.setFork(true);
        java.setFailonerror(true);
        java.setJar(new File(this.mxmlcPath));
        java.setProject(this.project);
        java.setDir(this.project.getBaseDir());
        java.setMaxmemory("256M");
        java.setErrorProperty("MXMLC_ERROR");
        Commandline.Argument argument2 = java.createArg();
        argument2.setLine("+flexlib \"" + string + "\"");
        if (this.configuration.getPlayer().equals("air")) {
            argument = java.createArg();
            argument.setValue("+configname=air");
        }
        argument = java.createArg();
        argument.setLine("-output \"" + file2.getAbsolutePath() + "\"");
        Commandline.Argument argument3 = java.createArg();
        argument3.setLine("-source-path " + this.configuration.getSources().getPathElements(" ") + " " + this.configuration.getTestSources().getPathElements(" "));
        this.determineLibraryPath(java);
        this.determineLoadConfigArgument(java);
        Commandline.Argument argument4 = java.createArg();
        argument4.setLine("-debug=" + this.configuration.getDebug());
        Commandline.Argument argument5 = java.createArg();
        argument5.setLine("-headless-server=true");
        Commandline.Argument argument6 = java.createArg();
        argument6.setValue(file.getAbsolutePath());
        return java;
    }

    private void determineLoadConfigArgument(Java java) {
        if (this.configuration.getLoadConfig() != null) {
            Commandline.Argument argument = java.createArg();
            argument.setLine(this.configuration.getLoadConfig().getCommandLineArgument());
        }
    }

    private void determineLibraryPath(Java java) {
        if (!this.configuration.getLibraries().getPathElements(" -library-path+=").isEmpty()) {
            Commandline.Argument argument = java.createArg();
            argument.setLine("-library-path+=" + this.configuration.getLibraries().getPathElements(" -library-path+="));
        }
    }
}

