/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class UnresolvedCallExpression
implements Expression {
    private final ContextResolvedFunction resolvedFunction;
    private final List<Expression> args;

    UnresolvedCallExpression(ContextResolvedFunction resolvedFunction, List<Expression> args) {
        this.resolvedFunction = resolvedFunction;
        this.args = Collections.unmodifiableList((List)Preconditions.checkNotNull(args, (String)"Arguments must not be null."));
    }

    public Optional<FunctionIdentifier> getFunctionIdentifier() {
        return this.resolvedFunction.getIdentifier();
    }

    public FunctionDefinition getFunctionDefinition() {
        return this.resolvedFunction.getDefinition();
    }

    public UnresolvedCallExpression replaceArgs(List<Expression> args) {
        return new UnresolvedCallExpression(this.resolvedFunction, args);
    }

    public CallExpression resolve(List<ResolvedExpression> args, DataType dataType) {
        return this.resolvedFunction.toCallExpression(args, dataType);
    }

    @Override
    public String asSummaryString() {
        String functionName = this.resolvedFunction.asSummaryString();
        String argList = this.args.stream().map(Expression::asSummaryString).collect(Collectors.joining(", ", "(", ")"));
        return functionName + argList;
    }

    @Override
    public List<Expression> getChildren() {
        return this.args;
    }

    @Override
    public <R> R accept(ExpressionVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnresolvedCallExpression that = (UnresolvedCallExpression)o;
        return this.resolvedFunction.equals(that.resolvedFunction) && this.args.equals(that.args);
    }

    public int hashCode() {
        return Objects.hash(this.resolvedFunction, this.args);
    }

    public String toString() {
        return this.asSummaryString();
    }
}

