/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep;

import org.apache.flink.annotation.Internal;
import org.apache.flink.cep.PatternFlatSelectFunction;
import org.apache.flink.cep.PatternFlatTimeoutFunction;
import org.apache.flink.cep.PatternSelectFunction;
import org.apache.flink.cep.PatternTimeoutFunction;
import org.apache.flink.cep.functions.PatternProcessFunction;
import org.apache.flink.cep.functions.adaptors.PatternFlatSelectAdapter;
import org.apache.flink.cep.functions.adaptors.PatternSelectAdapter;
import org.apache.flink.cep.functions.adaptors.PatternTimeoutFlatSelectAdapter;
import org.apache.flink.cep.functions.adaptors.PatternTimeoutSelectAdapter;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

@Internal
class PatternProcessFunctionBuilder {
    PatternProcessFunctionBuilder() {
    }

    static <IN, OUT> FlatSelectBuilder<IN, OUT> fromFlatSelect(PatternFlatSelectFunction<IN, OUT> function) {
        return new FlatSelectBuilder<IN, OUT>(function);
    }

    static <IN, OUT> SelectBuilder<IN, OUT> fromSelect(PatternSelectFunction<IN, OUT> function) {
        return new SelectBuilder<IN, OUT>(function);
    }

    static class TimeoutSelectBuilder<IN, OUT, TIMED_OUT> {
        private final PatternSelectFunction<IN, OUT> selectFunction;
        private final PatternTimeoutFunction<IN, TIMED_OUT> timeoutHandler;
        private final OutputTag<TIMED_OUT> outputTag;

        TimeoutSelectBuilder(PatternSelectFunction<IN, OUT> flatSelectFunction, PatternTimeoutFunction<IN, TIMED_OUT> timeoutHandler, OutputTag<TIMED_OUT> outputTag) {
            this.selectFunction = (PatternSelectFunction)Preconditions.checkNotNull(flatSelectFunction);
            this.timeoutHandler = (PatternTimeoutFunction)Preconditions.checkNotNull(timeoutHandler);
            this.outputTag = (OutputTag)Preconditions.checkNotNull(outputTag);
        }

        PatternProcessFunction<IN, OUT> build() {
            return new PatternTimeoutSelectAdapter<IN, OUT, TIMED_OUT>(this.selectFunction, this.timeoutHandler, this.outputTag);
        }
    }

    static class SelectBuilder<IN, OUT> {
        private final PatternSelectFunction<IN, OUT> selectFunction;

        SelectBuilder(PatternSelectFunction<IN, OUT> function) {
            this.selectFunction = (PatternSelectFunction)Preconditions.checkNotNull(function);
        }

        <TIMED_OUT> TimeoutSelectBuilder<IN, OUT, TIMED_OUT> withTimeoutHandler(OutputTag<TIMED_OUT> outputTag, PatternTimeoutFunction<IN, TIMED_OUT> timeoutHandler) {
            return new TimeoutSelectBuilder<IN, OUT, TIMED_OUT>(this.selectFunction, timeoutHandler, outputTag);
        }

        PatternProcessFunction<IN, OUT> build() {
            return new PatternSelectAdapter<IN, OUT>(this.selectFunction);
        }
    }

    static class FlatTimeoutSelectBuilder<IN, OUT, TIMED_OUT> {
        private final PatternFlatSelectFunction<IN, OUT> flatSelectFunction;
        private final PatternFlatTimeoutFunction<IN, TIMED_OUT> timeoutHandler;
        private final OutputTag<TIMED_OUT> outputTag;

        FlatTimeoutSelectBuilder(PatternFlatSelectFunction<IN, OUT> flatSelectFunction, PatternFlatTimeoutFunction<IN, TIMED_OUT> timeoutHandler, OutputTag<TIMED_OUT> outputTag) {
            this.flatSelectFunction = (PatternFlatSelectFunction)Preconditions.checkNotNull(flatSelectFunction);
            this.timeoutHandler = (PatternFlatTimeoutFunction)Preconditions.checkNotNull(timeoutHandler);
            this.outputTag = (OutputTag)Preconditions.checkNotNull(outputTag);
        }

        PatternProcessFunction<IN, OUT> build() {
            return new PatternTimeoutFlatSelectAdapter<IN, OUT, TIMED_OUT>(this.flatSelectFunction, this.timeoutHandler, this.outputTag);
        }
    }

    static class FlatSelectBuilder<IN, OUT> {
        private final PatternFlatSelectFunction<IN, OUT> flatSelectFunction;

        FlatSelectBuilder(PatternFlatSelectFunction<IN, OUT> function) {
            this.flatSelectFunction = (PatternFlatSelectFunction)Preconditions.checkNotNull(function);
        }

        <TIMED_OUT> FlatTimeoutSelectBuilder<IN, OUT, TIMED_OUT> withTimeoutHandler(OutputTag<TIMED_OUT> outputTag, PatternFlatTimeoutFunction<IN, TIMED_OUT> timeoutHandler) {
            return new FlatTimeoutSelectBuilder<IN, OUT, TIMED_OUT>(this.flatSelectFunction, timeoutHandler, outputTag);
        }

        PatternProcessFunction<IN, OUT> build() {
            return new PatternFlatSelectAdapter<IN, OUT>(this.flatSelectFunction);
        }
    }
}

