/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.lookup;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.collector.ListenableCollector;
import org.apache.flink.table.runtime.generated.GeneratedCollector;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.util.Collector;

public class LookupJoinRunner
extends ProcessFunction<RowData, RowData> {
    private static final long serialVersionUID = -4521543015709964733L;
    private final GeneratedFunction<FlatMapFunction<RowData, RowData>> generatedFetcher;
    private final GeneratedCollector<ListenableCollector<RowData>> generatedCollector;
    protected final boolean isLeftOuterJoin;
    protected final int tableFieldsCount;
    private transient FlatMapFunction<RowData, RowData> fetcher;
    protected transient ListenableCollector<RowData> collector;
    protected transient JoinedRowData outRow;
    private transient GenericRowData nullRow;

    public LookupJoinRunner(GeneratedFunction<FlatMapFunction<RowData, RowData>> generatedFetcher, GeneratedCollector<ListenableCollector<RowData>> generatedCollector, boolean isLeftOuterJoin, int tableFieldsCount) {
        this.generatedFetcher = generatedFetcher;
        this.generatedCollector = generatedCollector;
        this.isLeftOuterJoin = isLeftOuterJoin;
        this.tableFieldsCount = tableFieldsCount;
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.fetcher = (FlatMapFunction)this.generatedFetcher.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.collector = (ListenableCollector)((Object)this.generatedCollector.newInstance(this.getRuntimeContext().getUserCodeClassLoader()));
        FunctionUtils.setFunctionRuntimeContext(this.fetcher, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.setFunctionRuntimeContext(this.collector, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.fetcher, (Configuration)parameters);
        FunctionUtils.openFunction(this.collector, (Configuration)parameters);
        this.nullRow = new GenericRowData(this.tableFieldsCount);
        this.outRow = new JoinedRowData();
    }

    public void processElement(RowData in, ProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        this.prepareCollector(in, out);
        this.doFetch(in);
        this.padNullForLeftJoin(in, out);
    }

    public void prepareCollector(RowData in, Collector<RowData> out) {
        this.collector.setCollector(out);
        this.collector.setInput(in);
        this.collector.reset();
    }

    public void doFetch(RowData in) throws Exception {
        this.fetcher.flatMap((Object)in, this.getFetcherCollector());
    }

    public void padNullForLeftJoin(RowData in, Collector<RowData> out) {
        if (this.isLeftOuterJoin && !this.collector.isCollected()) {
            this.outRow.replace(in, (RowData)this.nullRow);
            this.outRow.setRowKind(in.getRowKind());
            out.collect((Object)this.outRow);
        }
    }

    public Collector<RowData> getFetcherCollector() {
        return this.collector;
    }

    public void close() throws Exception {
        if (this.fetcher != null) {
            FunctionUtils.closeFunction(this.fetcher);
        }
        if (this.collector != null) {
            FunctionUtils.closeFunction(this.collector);
        }
        super.close();
    }
}

