/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public class ArrayConcatFunction
extends BuiltInScalarFunction {
    private final ArrayData.ElementGetter elementGetter;

    public ArrayConcatFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.ARRAY_CONCAT, context);
        DataType dataType = ((CollectionDataType)context.getCallContext().getOutputDataType().get()).getElementDataType();
        this.elementGetter = ArrayData.createElementGetter((LogicalType)dataType.getLogicalType());
    }

    @Nullable
    public ArrayData eval(ArrayData ... arrays) {
        if (arrays == null || arrays.length == 0) {
            return null;
        }
        if (arrays.length == 1) {
            return arrays[0];
        }
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            for (ArrayData array : arrays) {
                if (array == null) {
                    return null;
                }
                this.appendElements(array, this.elementGetter, list);
            }
            return new GenericArrayData(list.toArray());
        }
        catch (Throwable t) {
            throw new FlinkRuntimeException(t);
        }
    }

    void appendElements(ArrayData array, ArrayData.ElementGetter elementGetter, List<Object> list) throws Throwable {
        for (int i = 0; i < array.size(); ++i) {
            Object element = elementGetter.getElementOrNull(array, i);
            list.add(element);
        }
    }
}

