/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table.stream;

import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.functions.sink.filesystem.Bucket;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketLifeCycleListener;
import org.apache.flink.streaming.api.functions.sink.filesystem.Buckets;
import org.apache.flink.streaming.api.functions.sink.filesystem.StreamingFileSink;
import org.apache.flink.streaming.api.functions.sink.filesystem.StreamingFileSinkHelper;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public abstract class AbstractStreamingWriter<IN, OUT>
extends AbstractStreamOperator<OUT>
implements OneInputStreamOperator<IN, OUT>,
BoundedOneInput {
    private static final long serialVersionUID = 1L;
    private final long bucketCheckInterval;
    private final StreamingFileSink.BucketsBuilder<IN, String, ? extends StreamingFileSink.BucketsBuilder<IN, String, ?>> bucketsBuilder;
    protected transient Buckets<IN, String> buckets;
    private transient StreamingFileSinkHelper<IN> helper;
    protected transient long currentWatermark;

    public AbstractStreamingWriter(long bucketCheckInterval, StreamingFileSink.BucketsBuilder<IN, String, ? extends StreamingFileSink.BucketsBuilder<IN, String, ?>> bucketsBuilder) {
        this.bucketCheckInterval = bucketCheckInterval;
        this.bucketsBuilder = bucketsBuilder;
        this.setChainingStrategy(ChainingStrategy.ALWAYS);
    }

    protected abstract void partitionCreated(String var1);

    protected abstract void partitionInactive(String var1);

    protected abstract void onPartFileOpened(String var1, Path var2);

    protected void commitUpToCheckpoint(long checkpointId) throws Exception {
        this.helper.commitUpToCheckpoint(checkpointId);
    }

    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        this.buckets = this.bucketsBuilder.createBuckets(this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask());
        this.buckets.setBucketLifeCycleListener(new BucketLifeCycleListener<IN, String>(){

            public void bucketCreated(Bucket<IN, String> bucket) {
                AbstractStreamingWriter.this.partitionCreated((String)bucket.getBucketId());
            }

            public void bucketInactive(Bucket<IN, String> bucket) {
                AbstractStreamingWriter.this.partitionInactive((String)bucket.getBucketId());
            }
        });
        this.buckets.setFileLifeCycleListener(this::onPartFileOpened);
        this.helper = new StreamingFileSinkHelper(this.buckets, context.isRestored(), context.getOperatorStateStore(), this.getRuntimeContext().getProcessingTimeService(), this.bucketCheckInterval);
        this.currentWatermark = Long.MIN_VALUE;
    }

    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        this.helper.snapshotState(context.getCheckpointId());
    }

    public void processWatermark(Watermark mark) throws Exception {
        super.processWatermark(mark);
        this.currentWatermark = mark.getTimestamp();
    }

    public void processElement(StreamRecord<IN> element) throws Exception {
        this.helper.onElement(element.getValue(), this.getProcessingTimeService().getCurrentProcessingTime(), element.hasTimestamp() ? Long.valueOf(element.getTimestamp()) : null, this.currentWatermark);
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        super.notifyCheckpointComplete(checkpointId);
        this.commitUpToCheckpoint(checkpointId);
    }

    public void endInput() throws Exception {
        this.buckets.onProcessingTime(Long.MAX_VALUE);
        this.helper.snapshotState(Long.MAX_VALUE);
        this.output.emitWatermark(new Watermark(Long.MAX_VALUE));
        this.commitUpToCheckpoint(Long.MAX_VALUE);
    }

    public void close() throws Exception {
        super.close();
        if (this.helper != null) {
            this.helper.close();
        }
    }
}

