/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source.avroLegacy;

import com.cloudera.flume.handlers.avro.AvroFlumeOGEvent;
import com.cloudera.flume.handlers.avro.FlumeOGEventAvroServer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.jetty.HttpServer;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.CounterGroup;
import org.apache.flume.Event;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.conf.Configurable;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.source.AbstractSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroLegacySource
extends AbstractSource
implements EventDrivenSource,
Configurable,
FlumeOGEventAvroServer {
    static final Logger LOG = LoggerFactory.getLogger(AvroLegacySource.class);
    public static final String HOST = "host";
    public static final String TIMESTAMP = "timestamp";
    public static final String PRIORITY = "pri";
    public static final String NANOS = "nanos";
    public static final String OG_EVENT = "FlumeOG";
    private CounterGroup counterGroup = new CounterGroup();
    protected FlumeOGEventAvroServer avroClient;
    private String host;
    private int port;
    private SpecificResponder res;
    private HttpServer http;

    public void start() {
        this.res = new SpecificResponder(FlumeOGEventAvroServer.class, (Object)this);
        try {
            this.http = new HttpServer((Responder)this.res, this.host, this.port);
        }
        catch (IOException eI) {
            LOG.warn("Failed to start server", (Throwable)eI);
            return;
        }
        this.http.start();
        super.start();
    }

    public void stop() {
        this.http.close();
        super.stop();
    }

    @Override
    public void append(AvroFlumeOGEvent evt) {
        this.counterGroup.incrementAndGet("rpc.received");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(HOST, evt.getHost().toString());
        headers.put(TIMESTAMP, Long.toString(evt.getTimestamp()));
        headers.put(PRIORITY, evt.getPriority().toString());
        headers.put(NANOS, Long.toString(evt.getNanos()));
        for (Map.Entry<CharSequence, ByteBuffer> entry : evt.getFields().entrySet()) {
            headers.put(entry.getKey().toString(), entry.getValue().toString());
        }
        headers.put(OG_EVENT, "yes");
        Event event = EventBuilder.withBody((byte[])evt.getBody().array(), headers);
        try {
            this.getChannelProcessor().processEvent(event);
            this.counterGroup.incrementAndGet("rpc.events");
        }
        catch (ChannelException ex) {
            return;
        }
        this.counterGroup.incrementAndGet("rpc.successful");
    }

    public void configure(Context context) {
        this.port = Integer.parseInt(context.getString("port"));
        this.host = context.getString(HOST);
    }
}

