/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kafka.api.LeaderAndIsr;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.AlterIsrItem;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerToControllerChannelManager;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.AlterIsrRequestData;
import org.apache.kafka.common.message.AlterIsrResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterIsrRequest;
import org.apache.kafka.common.requests.AlterIsrResponse;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015e\u0001B\r\u001b\u0001}A\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005q!AA\b\u0001BC\u0002\u0013\u0005Q\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003?\u0011!\u0011\u0005A!b\u0001\n\u0003\u0019\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u0011E\u0003!Q1A\u0005\u0002IC\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t/\u0002\u0011)\u0019!C\u00011\"Aq\f\u0001B\u0001B\u0003%\u0011\fC\u0003a\u0001\u0011\u0005\u0011\rC\u0004i\u0001\t\u0007I\u0011B5\t\re\u0004\u0001\u0015!\u0003k\u0011\u001dQ\bA1A\u0005\nmDq!!\u0003\u0001A\u0003%A\u0010C\u0005\u0002\f\u0001\u0011\r\u0011\"\u0003\u0002\u000e!A\u0011Q\u0003\u0001!\u0002\u0013\ty\u0001C\u0004\u0002\u0018\u0001!\t%!\u0007\t\u000f\u0005\u0005\u0002\u0001\"\u0011\u0002$!9\u0011q\u0006\u0001\u0005B\u0005E\u0002bBA\u001c\u0001\u0011%\u0011\u0011\u0004\u0005\b\u0003s\u0001A\u0011BA\u001e\u0011\u001d\tI\u0006\u0001C\u0005\u00037Bq!a\u001b\u0001\t\u0003\tiGA\nBYR,'/S:s\u001b\u0006t\u0017mZ3s\u00136\u0004HN\u0003\u0002\u001c9\u000511/\u001a:wKJT\u0011!H\u0001\u0006W\u000647.Y\u0002\u0001'\u0015\u0001\u0001E\n\u00161!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0019\te.\u001f*fMB\u0011q\u0005K\u0007\u00025%\u0011\u0011F\u0007\u0002\u0010\u00032$XM]%te6\u000bg.Y4feB\u00111FL\u0007\u0002Y)\u0011Q\u0006H\u0001\u0006kRLGn]\u0005\u0003_1\u0012q\u0001T8hO&tw\r\u0005\u00022i5\t!G\u0003\u000249\u00059Q.\u001a;sS\u000e\u001c\u0018BA\u001b3\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f]\u0001\u0019G>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014X#\u0001\u001d\u0011\u0005\u001dJ\u0014B\u0001\u001e\u001b\u0005\u0001\u0012%o\\6feR{7i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u00023\r|g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'\u000fI\u0001\ng\u000eDW\rZ;mKJ,\u0012A\u0010\t\u0003W}J!\u0001\u0011\u0017\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sA\u0005!A/[7f+\u0005!\u0005CA#O\u001b\u00051%BA\u0017H\u0015\tA\u0015*\u0001\u0004d_6lwN\u001c\u0006\u0003;)S!a\u0013'\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0015aA8sO&\u0011qJ\u0012\u0002\u0005)&lW-A\u0003uS6,\u0007%\u0001\u0005ce>\\WM]%e+\u0005\u0019\u0006CA\u0011U\u0013\t)&EA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002'\t\u0014xn[3s\u000bB|7\r[*vaBd\u0017.\u001a:\u0016\u0003e\u00032!\t.]\u0013\tY&EA\u0005Gk:\u001cG/[8oaA\u0011\u0011%X\u0005\u0003=\n\u0012A\u0001T8oO\u0006!\"M]8lKJ,\u0005o\\2i'V\u0004\b\u000f\\5fe\u0002\na\u0001P5oSRtDC\u00022dI\u00164w\r\u0005\u0002(\u0001!)ag\u0003a\u0001q!)Ah\u0003a\u0001}!)!i\u0003a\u0001\t\")\u0011k\u0003a\u0001'\")qk\u0003a\u00013\u0006\u0001RO\\:f]RL5O]+qI\u0006$Xm]\u000b\u0002UB!1\u000e\u001d:w\u001b\u0005a'BA7o\u0003\u0011)H/\u001b7\u000b\u0003=\fAA[1wC&\u0011\u0011\u000f\u001c\u0002\u0004\u001b\u0006\u0004\bCA:u\u001b\u00059\u0015BA;H\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"aJ<\n\u0005aT\"\u0001D!mi\u0016\u0014\u0018j\u001d:Ji\u0016l\u0017!E;og\u0016tG/S:s+B$\u0017\r^3tA\u0005y\u0011N\u001c4mS\u001eDGOU3rk\u0016\u001cH/F\u0001}!\ri\u0018QA\u0007\u0002}*\u0019q0!\u0001\u0002\r\u0005$x.\\5d\u0015\r\t\u0019\u0001\\\u0001\u000bG>t7-\u001e:sK:$\u0018bAA\u0004}\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\f\u0001#\u001b8gY&<\u0007\u000e\u001e*fcV,7\u000f\u001e\u0011\u0002)1\f7\u000f^%teB\u0013x\u000e]1hCRLwN\\'t+\t\ty\u0001E\u0002~\u0003#I1!a\u0005\u007f\u0005)\tEo\\7jG2{gnZ\u0001\u0016Y\u0006\u001cH/S:s!J|\u0007/Y4bi&|g.T:!\u0003\u0015\u0019H/\u0019:u)\t\tY\u0002E\u0002\"\u0003;I1!a\b#\u0005\u0011)f.\u001b;\u0002\u000f\u0015t\u0017/^3vKR!\u0011QEA\u0016!\r\t\u0013qE\u0005\u0004\u0003S\u0011#a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003[\u0019\u0002\u0019\u0001<\u0002\u0019\u0005dG/\u001a:JgJLE/Z7\u0002\u0019\rdW-\u0019:QK:$\u0017N\\4\u0015\t\u0005m\u00111\u0007\u0005\u0007\u0003k!\u0002\u0019\u0001:\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0019\u0002O]8qC\u001e\fG/Z%te\u000eC\u0017M\\4fg\u0006Y1/\u001a8e%\u0016\fX/Z:u)\u0011\tY\"!\u0010\t\u000f\u0005}b\u00031\u0001\u0002B\u0005)\u0012N\u001c4mS\u001eDG/\u00117uKJL5O]%uK6\u001c\b#BA\"\u0003'2h\u0002BA#\u0003\u001frA!a\u0012\u0002N5\u0011\u0011\u0011\n\u0006\u0004\u0003\u0017r\u0012A\u0002\u001fs_>$h(C\u0001$\u0013\r\t\tFI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)&a\u0016\u0003\u0007M+\u0017OC\u0002\u0002R\t\nABY;jY\u0012\u0014V-];fgR$B!!\u0018\u0002jA!\u0011qLA3\u001b\t\t\tGC\u0002\u0002d\u001d\u000bq!\\3tg\u0006<W-\u0003\u0003\u0002h\u0005\u0005$aE!mi\u0016\u0014\u0018j\u001d:SKF,Xm\u001d;ECR\f\u0007bBA /\u0001\u0007\u0011\u0011I\u0001\u0017Q\u0006tG\r\\3BYR,'/S:s%\u0016\u001c\bo\u001c8tKRA\u00111DA8\u0003\u007f\n\u0019\tC\u0004\u0002ra\u0001\r!a\u001d\u0002!\u0005dG/\u001a:JgJ\u0014Vm\u001d9p]N,\u0007\u0003BA;\u0003wj!!a\u001e\u000b\u0007\u0005et)\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\ti(a\u001e\u0003!\u0005cG/\u001a:JgJ\u0014Vm\u001d9p]N,\u0007BBAA1\u0001\u0007A,A\btK:$(I]8lKJ,\u0005o\\2i\u0011\u001d\ty\u0004\u0007a\u0001\u0003\u0003\u0002")
public class AlterIsrManagerImpl
implements AlterIsrManager,
KafkaMetricsGroup {
    private final BrokerToControllerChannelManager controllerChannelManager;
    private final Scheduler scheduler;
    private final Time time;
    private final int brokerId;
    private final Function0<Object> brokerEpochSupplier;
    private final java.util.Map<TopicPartition, AlterIsrItem> unsentIsrUpdates;
    private final AtomicBoolean inflightRequest;
    private final AtomicLong lastIsrPropagationMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public BrokerToControllerChannelManager controllerChannelManager() {
        return this.controllerChannelManager;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Time time() {
        return this.time;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Function0<Object> brokerEpochSupplier() {
        return this.brokerEpochSupplier;
    }

    private java.util.Map<TopicPartition, AlterIsrItem> unsentIsrUpdates() {
        return this.unsentIsrUpdates;
    }

    private AtomicBoolean inflightRequest() {
        return this.inflightRequest;
    }

    private AtomicLong lastIsrPropagationMs() {
        return this.lastIsrPropagationMs;
    }

    @Override
    public void start() {
        this.scheduler().schedule("send-alter-isr", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.propagateIsrChanges(), 50L, 50L, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean enqueue(AlterIsrItem alterIsrItem) {
        return this.unsentIsrUpdates().putIfAbsent(alterIsrItem.topicPartition(), alterIsrItem) == null;
    }

    @Override
    public void clearPending(TopicPartition topicPartition) {
        this.unsentIsrUpdates().remove(topicPartition);
    }

    private void propagateIsrChanges() {
        if (!this.unsentIsrUpdates().isEmpty() && this.inflightRequest().compareAndSet(false, true)) {
            ListBuffer inflightAlterIsrItems = new ListBuffer();
            this.unsentIsrUpdates().values().forEach(item -> inflightAlterIsrItems.append(item));
            long now = this.time().milliseconds();
            this.lastIsrPropagationMs().set(now);
            this.sendRequest((scala.collection.immutable.Seq<AlterIsrItem>)inflightAlterIsrItems.toSeq());
        }
    }

    private void sendRequest(scala.collection.immutable.Seq<AlterIsrItem> inflightAlterIsrItems) {
        AlterIsrRequestData message = this.buildRequest(inflightAlterIsrItems);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Sending AlterIsr to controller ").append(message).toString());
        this.controllerChannelManager().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)new AlterIsrRequest.Builder(message), response -> this.responseHandler$1(response, message, inflightAlterIsrItems));
    }

    /*
     * WARNING - void declaration
     */
    private AlterIsrRequestData buildRequest(scala.collection.immutable.Seq<AlterIsrItem> inflightAlterIsrItems) {
        void var2_2;
        AlterIsrRequestData message = new AlterIsrRequestData().setBrokerId(this.brokerId()).setBrokerEpoch(this.brokerEpochSupplier().apply$mcJ$sp()).setTopics(new ArrayList());
        inflightAlterIsrItems.groupBy((Function1 & Serializable)x$1 -> x$1.topicPartition().topic()).foreach((Function1 & Serializable)entry -> {
            AlterIsrManagerImpl.$anonfun$buildRequest$2(message, entry);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public void handleAlterIsrResponse(AlterIsrResponse alterIsrResponse, long sentBrokerEpoch, scala.collection.immutable.Seq<AlterIsrItem> inflightAlterIsrItems) {
        AlterIsrResponseData data = alterIsrResponse.data();
        Errors errors = Errors.forCode((short)data.errorCode());
        if (Errors.STALE_BROKER_EPOCH.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Broker had a stale broker epoch (").append(sentBrokerEpoch).append("), retrying.").toString());
            return;
        }
        if (Errors.CLUSTER_AUTHORIZATION_FAILED.equals(errors)) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Broker is not authorized to send AlterIsr to controller", (Function0<Throwable>)(Function0 & Serializable)() -> Errors.CLUSTER_AUTHORIZATION_FAILED.exception("Broker is not authorized to send AlterIsr to controller"));
            return;
        }
        if (Errors.NONE.equals(errors)) {
            HashMap partitionResponses = new HashMap();
            data.topics().forEach(arg_0 -> AlterIsrManagerImpl.$anonfun$handleAlterIsrResponse$4(this, (scala.collection.mutable.Map)partitionResponses, arg_0));
            inflightAlterIsrItems.foreach(arg_0 -> AlterIsrManagerImpl.$anonfun$handleAlterIsrResponse$8$adapted(this, (scala.collection.mutable.Map)partitionResponses, arg_0));
            return;
        }
        if (errors != null) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(82).append("Controller returned an unexpected top-level error when handling AlterIsr request: ").append(errors).toString());
            return;
        }
        throw new MatchError(null);
    }

    private final void responseHandler$1(ClientResponse response, AlterIsrRequestData message$1, scala.collection.immutable.Seq inflightAlterIsrItems$2) {
        try {
            AlterIsrResponse body = (AlterIsrResponse)response.responseBody();
            this.handleAlterIsrResponse(body, message$1.brokerEpoch(), (scala.collection.immutable.Seq<AlterIsrItem>)inflightAlterIsrItems$2);
        }
        finally {
            if (!this.inflightRequest().compareAndSet(true, false)) {
                throw new IllegalStateException("AlterIsr response callback called when no requests were in flight");
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$buildRequest$3(AlterIsrRequestData.TopicData topicPart$1, AlterIsrItem item) {
        Object var3_4;
        Nil$ nil$;
        java.util.List list = topicPart$1.partitions();
        AlterIsrRequestData.PartitionData partitionData = new AlterIsrRequestData.PartitionData().setPartitionIndex(item.topicPartition().partition()).setLeaderEpoch(item.leaderAndIsr().leaderEpoch());
        List<Object> list2 = item.leaderAndIsr().isr();
        if (list2 == null) {
            throw null;
        }
        List<Object> map_this = list2;
        if (map_this == Nil$.MODULE$) {
            nil$ = Nil$.MODULE$;
        } else {
            .colon.colon map_h;
            .colon.colon map_t = map_h = new .colon.colon((Object)BoxesRunTime.unboxToInt((Object)map_this.head()), (List)Nil$.MODULE$);
            for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                .colon.colon map_nx = new .colon.colon((Object)BoxesRunTime.unboxToInt((Object)map_rest.head()), (List)Nil$.MODULE$);
                map_t.next_$eq((List)map_nx);
                map_t = map_nx;
            }
            Statics.releaseFence();
            nil$ = var3_4;
        }
        Nil$ nil$2 = nil$;
        Object var2_2 = null;
        var3_4 = null;
        Object var4_5 = null;
        Object var5_6 = null;
        Object var6_7 = null;
        nil$ = null;
        return list.add(partitionData.setNewIsr(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)nil$2).asJava()).setCurrentIsrVersion(item.leaderAndIsr().zkVersion()));
    }

    public static final /* synthetic */ void $anonfun$buildRequest$2(AlterIsrRequestData message$2, Tuple2 entry) {
        AlterIsrRequestData.TopicData topicPart = new AlterIsrRequestData.TopicData().setName((String)entry._1()).setPartitions(new ArrayList());
        message$2.topics().add(topicPart);
        ((IterableOnceOps)entry._2()).foreach((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)AlterIsrManagerImpl.$anonfun$buildRequest$3(topicPart, item)));
    }

    public static final /* synthetic */ void $anonfun$handleAlterIsrResponse$4(AlterIsrManagerImpl $this, scala.collection.mutable.Map partitionResponses$1, AlterIsrResponseData.TopicData topic) {
        topic.partitions().forEach(partition -> {
            TopicPartition tp = new TopicPartition(topic.name(), partition.partitionIndex());
            Errors error = Errors.forCode((short)partition.errorCode());
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Controller successfully handled AlterIsr request for ").append(tp).append(": ").append(partition).toString());
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                Nil$ nil$;
                int n = partition.leaderId();
                int n2 = partition.leaderEpoch();
                List list = AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)partition.isr()).asScala().toList();
                if (list == null) {
                    throw null;
                }
                List map_this = list;
                if (map_this == Nil$.MODULE$) {
                    nil$ = Nil$.MODULE$;
                } else {
                    .colon.colon map_h;
                    .colon.colon map_t = map_h = new .colon.colon((Object)BoxesRunTime.unboxToInt((Object)((Integer)map_this.head())), (List)Nil$.MODULE$);
                    for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                        .colon.colon map_nx = new .colon.colon((Object)BoxesRunTime.unboxToInt((Object)((Integer)map_rest.head())), (List)Nil$.MODULE$);
                        map_t.next_$eq((List)map_nx);
                        map_t = map_nx;
                    }
                    Statics.releaseFence();
                    nil$ = map_h;
                }
                Nil$ nil$2 = nil$;
                Object var8_7 = null;
                Object var9_9 = null;
                Object var10_10 = null;
                Object var11_11 = null;
                Object var12_12 = null;
                nil$ = null;
                LeaderAndIsr newLeaderAndIsr = new LeaderAndIsr(n, n2, (List<Object>)nil$2, partition.currentIsrVersion());
                if (package$.MODULE$.Right() == null) {
                    throw null;
                }
                partitionResponses$1.update((Object)tp, (Object)new Right((Object)newLeaderAndIsr));
                return;
            }
            if (package$.MODULE$.Left() == null) {
                throw null;
            }
            partitionResponses$1.update((Object)tp, (Object)new Left((Object)error));
        });
    }

    public static final /* synthetic */ void $anonfun$handleAlterIsrResponse$8(AlterIsrManagerImpl $this, scala.collection.mutable.Map partitionResponses$1, AlterIsrItem inflightAlterIsr) {
        if (partitionResponses$1.contains((Object)inflightAlterIsr.topicPartition())) {
            try {
                inflightAlterIsr.callback().apply(partitionResponses$1.apply((Object)inflightAlterIsr.topicPartition()));
            }
            finally {
                $this.unsentIsrUpdates().remove(inflightAlterIsr.topicPartition());
            }
            return;
        }
        $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Partition ").append(inflightAlterIsr.topicPartition()).append(" was sent but not included in the response").toString());
    }

    public AlterIsrManagerImpl(BrokerToControllerChannelManager controllerChannelManager, Scheduler scheduler, Time time, int brokerId, Function0<Object> brokerEpochSupplier) {
        this.controllerChannelManager = controllerChannelManager;
        this.scheduler = scheduler;
        this.time = time;
        this.brokerId = brokerId;
        this.brokerEpochSupplier = brokerEpochSupplier;
        this.unsentIsrUpdates = new ConcurrentHashMap<TopicPartition, AlterIsrItem>();
        this.inflightRequest = new AtomicBoolean(false);
        this.lastIsrPropagationMs = new AtomicLong(0L);
    }

    public static final /* synthetic */ Object $anonfun$handleAlterIsrResponse$8$adapted(AlterIsrManagerImpl $this, scala.collection.mutable.Map partitionResponses$1, AlterIsrItem inflightAlterIsr) {
        AlterIsrManagerImpl.$anonfun$handleAlterIsrResponse$8($this, partitionResponses$1, inflightAlterIsr);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Integer $anonfun$buildRequest$4$adapted(Object x$1) {
        return BoxesRunTime.unboxToInt((Object)x$1);
    }

    public static final /* synthetic */ Object $anonfun$handleAlterIsrResponse$7$adapted(Integer x$2) {
        return BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2));
    }
}

