/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source.kafka;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kafka.cluster.BrokerEndPoint;
import kafka.zk.KafkaZkClient;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.commons.lang.StringUtils;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.PollableSource;
import org.apache.flume.conf.BatchSizeSupported;
import org.apache.flume.conf.Configurable;
import org.apache.flume.conf.ConfigurationException;
import org.apache.flume.conf.LogPrivacyUtil;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.instrumentation.kafka.KafkaSourceCounter;
import org.apache.flume.shared.kafka.KafkaSSLUtil;
import org.apache.flume.source.AbstractPollableSource;
import org.apache.flume.source.avro.AvroFlumeEvent;
import org.apache.flume.source.kafka.SourceRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class KafkaSource
extends AbstractPollableSource
implements Configurable,
BatchSizeSupported {
    private static final Logger log = LoggerFactory.getLogger(KafkaSource.class);
    private static final int ZK_SESSION_TIMEOUT = 30000;
    private static final int ZK_CONNECTION_TIMEOUT = 30000;
    private Context context;
    private Properties kafkaProps;
    private KafkaSourceCounter counter;
    private KafkaConsumer<String, byte[]> consumer;
    private Iterator<ConsumerRecord<String, byte[]>> it;
    private final List<Event> eventList = new ArrayList<Event>();
    private Map<TopicPartition, OffsetAndMetadata> tpAndOffsetMetadata;
    private AtomicBoolean rebalanceFlag;
    private Map<String, String> headers;
    private Optional<SpecificDatumReader<AvroFlumeEvent>> reader = Optional.absent();
    private BinaryDecoder decoder = null;
    private boolean useAvroEventFormat;
    private int batchUpperLimit;
    private int maxBatchDurationMillis;
    private Subscriber subscriber;
    private String zookeeperConnect;
    private String bootstrapServers;
    private String groupId = "flume";
    @Deprecated
    private boolean migrateZookeeperOffsets = true;
    private String topicHeader = null;
    private boolean setTopicHeader;
    private Map<String, String> headerMap;

    public long getBatchSize() {
        return this.batchUpperLimit;
    }

    protected PollableSource.Status doProcess() throws EventDeliveryException {
        String batchUUID = UUID.randomUUID().toString();
        try {
            long nanoBatchStartTime = System.nanoTime();
            long batchStartTime = System.currentTimeMillis();
            long maxBatchEndTime = System.currentTimeMillis() + (long)this.maxBatchDurationMillis;
            while (this.eventList.size() < this.batchUpperLimit && System.currentTimeMillis() < maxBatchEndTime) {
                byte[] eventBody;
                if (this.it == null || !this.it.hasNext()) {
                    long durMs = Math.max(0L, maxBatchEndTime - System.currentTimeMillis());
                    Duration duration = Duration.ofMillis(durMs);
                    ConsumerRecords consumerRecords = this.consumer.poll(duration);
                    this.it = consumerRecords.iterator();
                    if (this.rebalanceFlag.compareAndSet(true, false)) break;
                    if (!this.it.hasNext()) {
                        this.counter.incrementKafkaEmptyCount();
                        log.debug("Returning with backoff. No more data to read");
                        break;
                    }
                }
                ConsumerRecord<String, byte[]> message = this.it.next();
                String kafkaKey = (String)message.key();
                if (this.useAvroEventFormat) {
                    ByteArrayInputStream in = new ByteArrayInputStream((byte[])message.value());
                    this.decoder = DecoderFactory.get().directBinaryDecoder((InputStream)in, this.decoder);
                    if (!this.reader.isPresent()) {
                        this.reader = Optional.of((Object)new SpecificDatumReader(AvroFlumeEvent.class));
                    }
                    AvroFlumeEvent avroevent = (AvroFlumeEvent)((SpecificDatumReader)this.reader.get()).read(null, (Decoder)this.decoder);
                    eventBody = avroevent.getBody().array();
                    this.headers = KafkaSource.toStringMap(avroevent.getHeaders());
                } else {
                    eventBody = (byte[])message.value();
                    this.headers.clear();
                    this.headers = new HashMap<String, String>(4);
                }
                if (!this.headers.containsKey("timestamp")) {
                    this.headers.put("timestamp", String.valueOf(message.timestamp()));
                }
                if (!this.headerMap.isEmpty()) {
                    Headers kafkaHeaders = message.headers();
                    for (Map.Entry entry : this.headerMap.entrySet()) {
                        for (Header kafkaHeader : kafkaHeaders.headers((String)entry.getValue())) {
                            this.headers.put((String)entry.getKey(), new String(kafkaHeader.value()));
                        }
                    }
                }
                if (this.setTopicHeader && !this.headers.containsKey(this.topicHeader)) {
                    this.headers.put(this.topicHeader, message.topic());
                }
                if (!this.headers.containsKey("partition")) {
                    this.headers.put("partition", String.valueOf(message.partition()));
                }
                if (!this.headers.containsKey("offset")) {
                    this.headers.put("offset", String.valueOf(message.offset()));
                }
                if (kafkaKey != null) {
                    this.headers.put("key", kafkaKey);
                }
                if (log.isTraceEnabled()) {
                    if (LogPrivacyUtil.allowLogRawData()) {
                        log.trace("Topic: {} Partition: {} Message: {}", (Object[])new String[]{message.topic(), String.valueOf(message.partition()), new String(eventBody)});
                    } else {
                        log.trace("Topic: {} Partition: {} Message arrived.", (Object)message.topic(), (Object)String.valueOf(message.partition()));
                    }
                }
                Event event = EventBuilder.withBody((byte[])eventBody, this.headers);
                this.eventList.add(event);
                if (log.isDebugEnabled()) {
                    log.debug("Waited: {} ", (Object)(System.currentTimeMillis() - batchStartTime));
                    log.debug("Event #: {}", (Object)this.eventList.size());
                }
                this.tpAndOffsetMetadata.put(new TopicPartition(message.topic(), message.partition()), new OffsetAndMetadata(message.offset() + 1L, batchUUID));
            }
            if (this.eventList.size() > 0) {
                this.counter.addToKafkaEventGetTimer((System.nanoTime() - nanoBatchStartTime) / 1000000L);
                this.counter.addToEventReceivedCount((long)this.eventList.size());
                this.getChannelProcessor().processEventBatch(this.eventList);
                this.counter.addToEventAcceptedCount((long)this.eventList.size());
                if (log.isDebugEnabled()) {
                    log.debug("Wrote {} events to channel", (Object)this.eventList.size());
                }
                this.eventList.clear();
                if (!this.tpAndOffsetMetadata.isEmpty()) {
                    long commitStartTime = System.nanoTime();
                    this.consumer.commitSync(this.tpAndOffsetMetadata);
                    long commitEndTime = System.nanoTime();
                    this.counter.addToKafkaCommitTimer((commitEndTime - commitStartTime) / 1000000L);
                    this.tpAndOffsetMetadata.clear();
                }
                return PollableSource.Status.READY;
            }
            return PollableSource.Status.BACKOFF;
        }
        catch (Exception e) {
            log.error("KafkaSource EXCEPTION, {}", (Throwable)e);
            this.counter.incrementEventReadOrChannelFail((Throwable)e);
            return PollableSource.Status.BACKOFF;
        }
    }

    protected void doConfigure(Context context) throws FlumeException {
        String groupIdProperty;
        this.context = context;
        this.headers = new HashMap<String, String>(4);
        this.tpAndOffsetMetadata = new HashMap<TopicPartition, OffsetAndMetadata>();
        this.rebalanceFlag = new AtomicBoolean(false);
        this.kafkaProps = new Properties();
        this.translateOldProperties(context);
        String topicProperty = context.getString("kafka.topics.regex");
        if (topicProperty != null && !topicProperty.isEmpty()) {
            this.subscriber = new PatternSubscriber(topicProperty);
        } else {
            topicProperty = context.getString("kafka.topics");
            if (topicProperty != null && !topicProperty.isEmpty()) {
                this.subscriber = new TopicListSubscriber(topicProperty);
            } else if (this.subscriber == null) {
                throw new ConfigurationException("At least one Kafka topic must be specified.");
            }
        }
        this.batchUpperLimit = context.getInteger("batchSize", Integer.valueOf(1000));
        this.maxBatchDurationMillis = context.getInteger("batchDurationMillis", Integer.valueOf(1000));
        this.useAvroEventFormat = context.getBoolean("useFlumeEventFormat", Boolean.valueOf(false));
        if (log.isDebugEnabled()) {
            log.debug("useFlumeEventFormat set to: {}", (Object)this.useAvroEventFormat);
        }
        this.zookeeperConnect = context.getString("zookeeperConnect");
        this.migrateZookeeperOffsets = context.getBoolean("migrateZookeeperOffsets", Boolean.valueOf(true));
        this.bootstrapServers = context.getString("kafka.bootstrap.servers");
        if (this.bootstrapServers == null || this.bootstrapServers.isEmpty()) {
            if (this.zookeeperConnect == null || this.zookeeperConnect.isEmpty()) {
                throw new ConfigurationException("Bootstrap Servers must be specified");
            }
            log.warn("{} is deprecated. Please use the parameter {}", (Object)"zookeeperConnect", (Object)"kafka.bootstrap.servers");
            String securityProtocolStr = (String)context.getSubProperties("kafka.consumer.").get("security.protocol");
            if (securityProtocolStr == null || securityProtocolStr.isEmpty()) {
                securityProtocolStr = "PLAINTEXT";
            }
            this.bootstrapServers = this.lookupBootstrap(this.zookeeperConnect, SecurityProtocol.valueOf((String)securityProtocolStr));
        }
        if ((groupIdProperty = context.getString("kafka.consumer.group.id")) != null && !groupIdProperty.isEmpty()) {
            this.groupId = groupIdProperty;
        }
        if (this.groupId == null || this.groupId.isEmpty()) {
            this.groupId = "flume";
            log.info("Group ID was not specified. Using {} as the group id.", (Object)this.groupId);
        }
        this.setTopicHeader = context.getBoolean("setTopicHeader", Boolean.valueOf(true));
        this.topicHeader = context.getString("topicHeader", "topic");
        this.headerMap = context.getSubProperties("header.");
        this.setConsumerProps(context);
        if (log.isDebugEnabled() && LogPrivacyUtil.allowLogPrintConfig()) {
            log.debug("Kafka consumer properties: {}", (Object)this.kafkaProps);
        }
        if (this.counter == null) {
            this.counter = new KafkaSourceCounter(this.getName());
        }
    }

    private void translateOldProperties(Context ctx) {
        String topic = this.context.getString("topic");
        if (topic != null && !topic.isEmpty()) {
            this.subscriber = new TopicListSubscriber(topic);
            log.warn("{} is deprecated. Please use the parameter {}", (Object)"topic", (Object)"kafka.topics");
        }
        this.groupId = ctx.getString("groupId");
        if (this.groupId != null && !this.groupId.isEmpty()) {
            log.warn("{} is deprecated. Please use the parameter {}", (Object)"groupId", (Object)"kafka.consumer.group.id");
        }
    }

    private void setConsumerProps(Context ctx) {
        this.kafkaProps.clear();
        this.kafkaProps.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        this.kafkaProps.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        this.kafkaProps.putAll((Map<?, ?>)ctx.getSubProperties("kafka.consumer."));
        this.kafkaProps.put("bootstrap.servers", this.bootstrapServers);
        if (this.groupId != null) {
            this.kafkaProps.put("group.id", this.groupId);
        }
        this.kafkaProps.put("enable.auto.commit", "false");
        if (KafkaSSLUtil.isSSLEnabled((Properties)this.kafkaProps) && "true".equalsIgnoreCase(this.kafkaProps.getProperty("ssl.disableTLSHostnameVerification"))) {
            this.kafkaProps.put("ssl.endpoint.identification.algorithm", "");
        }
        KafkaSSLUtil.addGlobalSSLParameters((Properties)this.kafkaProps);
    }

    private String lookupBootstrap(String zookeeperConnect, SecurityProtocol securityProtocol) {
        try (KafkaZkClient zkClient = KafkaZkClient.apply((String)zookeeperConnect, (boolean)JaasUtils.isZkSaslEnabled(), (int)30000, (int)30000, (int)10, (Time)Time.SYSTEM, (String)"kafka.server", (String)"SessionExpireListener", (Option)Option.empty(), (Option)Option.empty());){
            List brokerList = (List)JavaConverters.seqAsJavaListConverter((Seq)zkClient.getAllBrokersInCluster()).asJava();
            List endPoints = brokerList.stream().map(broker -> broker.brokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol))).collect(Collectors.toList());
            ArrayList<String> connections = new ArrayList<String>();
            for (BrokerEndPoint endPoint : endPoints) {
                connections.add(endPoint.connectionString());
            }
            String string = StringUtils.join(connections, (char)',');
            return string;
        }
    }

    @VisibleForTesting
    String getBootstrapServers() {
        return this.bootstrapServers;
    }

    Properties getConsumerProps() {
        return this.kafkaProps;
    }

    private static Map<String, String> toStringMap(Map<CharSequence, CharSequence> charSeqMap) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        for (Map.Entry<CharSequence, CharSequence> entry : charSeqMap.entrySet()) {
            stringMap.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return stringMap;
    }

    <T> Subscriber<T> getSubscriber() {
        return this.subscriber;
    }

    protected void doStart() throws FlumeException {
        log.info("Starting {}...", (Object)this);
        if (this.migrateZookeeperOffsets && this.zookeeperConnect != null && !this.zookeeperConnect.isEmpty()) {
            if (this.subscriber instanceof TopicListSubscriber && ((TopicListSubscriber)this.subscriber).get().size() == 1) {
                String topicStr = (String)((TopicListSubscriber)this.subscriber).get().get(0);
                this.migrateOffsets(topicStr);
            } else {
                log.info("Will not attempt to migrate offsets because multiple topics or a pattern are defined");
            }
        }
        this.consumer = new KafkaConsumer(this.kafkaProps);
        this.subscriber.subscribe(this.consumer, new SourceRebalanceListener(this.rebalanceFlag));
        log.info("Kafka source {} started.", (Object)this.getName());
        this.counter.start();
    }

    protected void doStop() throws FlumeException {
        if (this.consumer != null) {
            this.consumer.wakeup();
            this.consumer.close();
        }
        if (this.counter != null) {
            this.counter.stop();
        }
        log.info("Kafka Source {} stopped. Metrics: {}", (Object)this.getName(), (Object)this.counter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void migrateOffsets(String topicStr) {
        try (KafkaZkClient zkClient = KafkaZkClient.apply((String)this.zookeeperConnect, (boolean)JaasUtils.isZkSaslEnabled(), (int)30000, (int)30000, (int)10, (Time)Time.SYSTEM, (String)"kafka.server", (String)"SessionExpireListener", (Option)Option.empty(), (Option)Option.empty());
             KafkaConsumer consumer = new KafkaConsumer(this.kafkaProps);){
            Map<TopicPartition, OffsetAndMetadata> kafkaOffsets = this.getKafkaOffsets((KafkaConsumer<String, byte[]>)consumer, topicStr);
            if (kafkaOffsets == null) {
                log.warn("Topic " + topicStr + " not found in Kafka. Offset migration will be skipped.");
                return;
            }
            if (!kafkaOffsets.isEmpty()) {
                log.info("Found Kafka offsets for topic " + topicStr + ". Will not migrate from zookeeper");
                log.debug("Offsets found: {}", kafkaOffsets);
                return;
            }
            log.info("No Kafka offsets found. Migrating zookeeper offsets");
            Map<TopicPartition, OffsetAndMetadata> zookeeperOffsets = this.getZookeeperOffsets(zkClient, (KafkaConsumer<String, byte[]>)consumer, topicStr);
            if (zookeeperOffsets.isEmpty()) {
                log.warn("No offsets to migrate found in Zookeeper");
                return;
            }
            log.info("Committing Zookeeper offsets to Kafka");
            log.debug("Offsets to commit: {}", zookeeperOffsets);
            consumer.commitSync(zookeeperOffsets);
            Map<TopicPartition, OffsetAndMetadata> newKafkaOffsets = this.getKafkaOffsets((KafkaConsumer<String, byte[]>)consumer, topicStr);
            log.debug("Offsets committed: {}", newKafkaOffsets);
            if (newKafkaOffsets == null) throw new FlumeException("Offsets could not be committed");
            if (newKafkaOffsets.keySet().containsAll(zookeeperOffsets.keySet())) return;
            throw new FlumeException("Offsets could not be committed");
        }
    }

    private Map<TopicPartition, OffsetAndMetadata> getKafkaOffsets(KafkaConsumer<String, byte[]> client, String topicStr) {
        HashMap<TopicPartition, OffsetAndMetadata> offsets = null;
        List partitions = client.partitionsFor(topicStr);
        if (partitions != null) {
            offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            for (PartitionInfo partition : partitions) {
                TopicPartition key = new TopicPartition(topicStr, partition.partition());
                OffsetAndMetadata offsetAndMetadata = client.committed(key);
                if (offsetAndMetadata == null) continue;
                offsets.put(key, offsetAndMetadata);
            }
        }
        return offsets;
    }

    private Map<TopicPartition, OffsetAndMetadata> getZookeeperOffsets(KafkaZkClient zkClient, KafkaConsumer<String, byte[]> consumer, String topicStr) {
        HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        List partitions = consumer.partitionsFor(topicStr);
        for (PartitionInfo partition : partitions) {
            TopicPartition topicPartition = new TopicPartition(topicStr, partition.partition());
            Option optionOffset = zkClient.getConsumerOffset(this.groupId, topicPartition);
            if (!optionOffset.nonEmpty()) continue;
            Long offset = (Long)optionOffset.get();
            OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(offset.longValue());
            offsets.put(topicPartition, offsetAndMetadata);
        }
        return offsets;
    }

    private class PatternSubscriber
    extends Subscriber<Pattern> {
        private Pattern pattern;

        public PatternSubscriber(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public void subscribe(KafkaConsumer<?, ?> consumer, SourceRebalanceListener listener) {
            consumer.subscribe(this.pattern, (ConsumerRebalanceListener)listener);
        }

        @Override
        public Pattern get() {
            return this.pattern;
        }
    }

    private class TopicListSubscriber
    extends Subscriber<List<String>> {
        private List<String> topicList;

        public TopicListSubscriber(String commaSeparatedTopics) {
            this.topicList = Arrays.asList(commaSeparatedTopics.split("^\\s+|\\s*,\\s*|\\s+$"));
        }

        @Override
        public void subscribe(KafkaConsumer<?, ?> consumer, SourceRebalanceListener listener) {
            consumer.subscribe(this.topicList, (ConsumerRebalanceListener)listener);
        }

        @Override
        public List<String> get() {
            return this.topicList;
        }
    }

    public abstract class Subscriber<T> {
        public abstract void subscribe(KafkaConsumer<?, ?> var1, SourceRebalanceListener var2);

        public T get() {
            return null;
        }
    }
}

