/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.solr.morphline;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.util.Map;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.sink.solr.morphline.MorphlineHandler;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.ExceptionHandler;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.Compiler;
import org.kitesdk.morphline.base.FaultTolerance;
import org.kitesdk.morphline.base.Notifications;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphlineHandlerImpl
implements MorphlineHandler {
    private MorphlineContext morphlineContext;
    private Command morphline;
    private Command finalChild;
    private String morphlineFileAndId;
    private Timer mappingTimer;
    private Meter numRecords;
    private Meter numFailedRecords;
    private Meter numExceptionRecords;
    public static final String MORPHLINE_FILE_PARAM = "morphlineFile";
    public static final String MORPHLINE_ID_PARAM = "morphlineId";
    public static final String MORPHLINE_VARIABLE_PARAM = "morphlineVariable";
    private static final Logger LOG = LoggerFactory.getLogger(MorphlineHandlerImpl.class);

    void setMorphlineContext(MorphlineContext morphlineContext) {
        this.morphlineContext = morphlineContext;
    }

    void setFinalChild(Command finalChild) {
        this.finalChild = finalChild;
    }

    public void configure(Context context) {
        String morphlineFile = context.getString(MORPHLINE_FILE_PARAM);
        String morphlineId = context.getString(MORPHLINE_ID_PARAM);
        if (morphlineFile == null || morphlineFile.trim().length() == 0) {
            throw new MorphlineCompilationException("Missing parameter: morphlineFile", null);
        }
        this.morphlineFileAndId = morphlineFile + "@" + morphlineId;
        if (this.morphlineContext == null) {
            FaultTolerance faultTolerance = new FaultTolerance(context.getBoolean("isProductionMode", Boolean.valueOf(false)).booleanValue(), context.getBoolean("isIgnoringRecoverableExceptions", Boolean.valueOf(false)).booleanValue(), context.getString("recoverableExceptionClasses"));
            this.morphlineContext = new MorphlineContext.Builder().setExceptionHandler((ExceptionHandler)faultTolerance).setMetricRegistry(SharedMetricRegistries.getOrCreate((String)this.morphlineFileAndId)).build();
        }
        Config override = ConfigFactory.parseMap((Map)context.getSubProperties("morphlineVariable."));
        this.morphline = new Compiler().compile(new File(morphlineFile), morphlineId, this.morphlineContext, this.finalChild, new Config[]{override});
        this.mappingTimer = this.morphlineContext.getMetricRegistry().timer(MetricRegistry.name((String)"morphline.app", (String[])new String[]{"elapsedTime"}));
        this.numRecords = this.morphlineContext.getMetricRegistry().meter(MetricRegistry.name((String)"morphline.app", (String[])new String[]{"numRecords"}));
        this.numFailedRecords = this.morphlineContext.getMetricRegistry().meter(MetricRegistry.name((String)"morphline.app", (String[])new String[]{"numFailedRecords"}));
        this.numExceptionRecords = this.morphlineContext.getMetricRegistry().meter(MetricRegistry.name((String)"morphline.app", (String[])new String[]{"numExceptionRecords"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Event event) {
        this.numRecords.mark();
        Timer.Context timerContext = this.mappingTimer.time();
        try {
            Record record = new Record();
            for (Map.Entry entry : event.getHeaders().entrySet()) {
                record.put((String)entry.getKey(), entry.getValue());
            }
            byte[] bytes = event.getBody();
            if (bytes != null && bytes.length > 0) {
                record.put("_attachment_body", (Object)bytes);
            }
            try {
                Notifications.notifyStartSession((Command)this.morphline);
                if (!this.morphline.process(record)) {
                    this.numFailedRecords.mark();
                    LOG.warn("Morphline {} failed to process record: {}", (Object)this.morphlineFileAndId, (Object)record);
                }
            }
            catch (RuntimeException t) {
                this.numExceptionRecords.mark();
                this.morphlineContext.getExceptionHandler().handleException((Throwable)t, record);
            }
        }
        finally {
            timerContext.stop();
        }
    }

    @Override
    public void beginTransaction() {
        Notifications.notifyBeginTransaction((Command)this.morphline);
    }

    @Override
    public void commitTransaction() {
        Notifications.notifyCommitTransaction((Command)this.morphline);
    }

    @Override
    public void rollbackTransaction() {
        Notifications.notifyRollbackTransaction((Command)this.morphline);
    }

    @Override
    public void stop() {
        Notifications.notifyShutdown((Command)this.morphline);
    }
}

