/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.solr.morphline;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.interceptor.Interceptor;
import org.apache.flume.sink.solr.morphline.MorphlineHandlerImpl;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.Record;

public class MorphlineInterceptor
implements Interceptor {
    private final Context context;
    private final Queue<LocalMorphlineInterceptor> pool = new ConcurrentLinkedQueue<LocalMorphlineInterceptor>();

    protected MorphlineInterceptor(Context context) {
        Preconditions.checkNotNull((Object)context);
        this.context = context;
        this.returnToPool(new LocalMorphlineInterceptor(context));
    }

    public void initialize() {
    }

    public void close() {
        LocalMorphlineInterceptor interceptor;
        while ((interceptor = this.pool.poll()) != null) {
            interceptor.close();
        }
    }

    public List<Event> intercept(List<Event> events) {
        LocalMorphlineInterceptor interceptor = this.borrowFromPool();
        List<Event> results = interceptor.intercept(events);
        this.returnToPool(interceptor);
        return results;
    }

    public Event intercept(Event event) {
        LocalMorphlineInterceptor interceptor = this.borrowFromPool();
        Event result = interceptor.intercept(event);
        this.returnToPool(interceptor);
        return result;
    }

    private void returnToPool(LocalMorphlineInterceptor interceptor) {
        this.pool.add(interceptor);
    }

    private LocalMorphlineInterceptor borrowFromPool() {
        LocalMorphlineInterceptor interceptor = this.pool.poll();
        if (interceptor == null) {
            interceptor = new LocalMorphlineInterceptor(this.context);
        }
        return interceptor;
    }

    private static final class Collector
    implements Command {
        private final List<Record> results = new ArrayList<Record>();

        private Collector() {
        }

        public List<Record> getRecords() {
            return this.results;
        }

        public void reset() {
            this.results.clear();
        }

        public Command getParent() {
            return null;
        }

        public void notify(Record notification) {
        }

        public boolean process(Record record) {
            Preconditions.checkNotNull((Object)record);
            this.results.add(record);
            return true;
        }
    }

    private static final class LocalMorphlineInterceptor
    implements Interceptor {
        private final MorphlineHandlerImpl morphline = new MorphlineHandlerImpl();
        private final Collector collector = new Collector();

        protected LocalMorphlineInterceptor(Context context) {
            this.morphline.setFinalChild(this.collector);
            this.morphline.configure(context);
        }

        public void initialize() {
        }

        public void close() {
            this.morphline.stop();
        }

        public List<Event> intercept(List<Event> events) {
            ArrayList<Event> results = new ArrayList<Event>(events.size());
            for (Event event : events) {
                if ((event = this.intercept(event)) == null) continue;
                results.add(event);
            }
            return results;
        }

        public Event intercept(Event event) {
            this.collector.reset();
            this.morphline.process(event);
            List<Record> results = this.collector.getRecords();
            if (results.size() == 0) {
                return null;
            }
            if (results.size() > 1) {
                throw new FlumeException(this.getClass().getName() + " must not generate more than one output record per input event");
            }
            Event result = this.toEvent(results.get(0));
            return result;
        }

        private Event toEvent(Record record) {
            HashMap headers = new HashMap();
            Map recordMap = record.getFields().asMap();
            byte[] body = null;
            for (Map.Entry entry : recordMap.entrySet()) {
                if (((Collection)entry.getValue()).size() > 1) {
                    throw new FlumeException(this.getClass().getName() + " must not generate more than one output value per record field");
                }
                assert (((Collection)entry.getValue()).size() != 0);
                Object firstValue = ((Collection)entry.getValue()).iterator().next();
                if ("_attachment_body".equals(entry.getKey())) {
                    if (firstValue instanceof byte[]) {
                        body = (byte[])firstValue;
                        continue;
                    }
                    if (firstValue instanceof InputStream) {
                        try {
                            body = ByteStreams.toByteArray((InputStream)((InputStream)firstValue));
                            continue;
                        }
                        catch (IOException e) {
                            throw new FlumeException((Throwable)e);
                        }
                    }
                    throw new FlumeException(this.getClass().getName() + " must non generate attachments that are not a byte[] or InputStream");
                }
                headers.put(entry.getKey(), firstValue.toString());
            }
            return EventBuilder.withBody(body, headers);
        }
    }

    public static class Builder
    implements Interceptor.Builder {
        private Context context;

        public MorphlineInterceptor build() {
            return new MorphlineInterceptor(this.context);
        }

        public void configure(Context context) {
            this.context = context;
        }
    }
}

