/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import java.util.Arrays;
import org.hbase.async.Bytes;
import org.hbase.async.RegionInfo;

public final class RegionLocation {
    private final byte[] table;
    private final byte[] region_name;
    private final String host;
    private final int port;
    private final byte[] start_key;
    private final byte[] stop_key;

    RegionLocation(RegionInfo region_info, byte[] start_key, String host, int port) {
        this.table = Arrays.copyOf(region_info.table(), region_info.table().length);
        this.region_name = Arrays.copyOf(region_info.name(), region_info.name().length);
        this.stop_key = Arrays.copyOf(region_info.stopKey(), region_info.stopKey().length);
        this.start_key = Arrays.copyOf(start_key, start_key.length);
        this.host = host;
        this.port = port;
    }

    public byte[] startKey() {
        return this.start_key;
    }

    public byte[] stopKey() {
        return this.stop_key;
    }

    public String getHostname() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public byte[] getTable() {
        return this.table;
    }

    public byte[] getRegionName() {
        return this.region_name;
    }

    public String toString() {
        return this.getClass().getCanonicalName() + "{hostport: " + this.host + ":" + this.port + ", startKey: " + Bytes.pretty(this.start_key) + ", stopKey:" + Bytes.pretty(this.stop_key) + ", table:" + Bytes.pretty(this.table) + ", name: " + Bytes.pretty(this.region_name) + "}";
    }
}

