/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source.taildir;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.flume.Event;
import org.apache.flume.event.EventBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TailFile {
    private static final Logger logger = LoggerFactory.getLogger(TailFile.class);
    private static final byte BYTE_NL = 10;
    private static final byte BYTE_CR = 13;
    private static final int BUFFER_SIZE = 8192;
    private static final int NEED_READING = -1;
    private RandomAccessFile raf;
    private final String path;
    private final long inode;
    private long pos;
    private long lastUpdated;
    private boolean needTail;
    private final Map<String, String> headers;
    private byte[] buffer;
    private byte[] oldBuffer;
    private int bufferPos;
    private long lineReadPos;

    public TailFile(File file, Map<String, String> headers, long inode, long pos) throws IOException {
        this.raf = new RandomAccessFile(file, "r");
        if (pos > 0L) {
            this.raf.seek(pos);
            this.lineReadPos = pos;
        }
        this.path = file.getAbsolutePath();
        this.inode = inode;
        this.pos = pos;
        this.lastUpdated = 0L;
        this.needTail = true;
        this.headers = headers;
        this.oldBuffer = new byte[0];
        this.bufferPos = -1;
    }

    public RandomAccessFile getRaf() {
        return this.raf;
    }

    public String getPath() {
        return this.path;
    }

    public long getInode() {
        return this.inode;
    }

    public long getPos() {
        return this.pos;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public boolean needTail() {
        return this.needTail;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public long getLineReadPos() {
        return this.lineReadPos;
    }

    public void setPos(long pos) {
        this.pos = pos;
    }

    public void setLastUpdated(long lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public void setNeedTail(boolean needTail) {
        this.needTail = needTail;
    }

    public void setLineReadPos(long lineReadPos) {
        this.lineReadPos = lineReadPos;
    }

    public boolean updatePos(String path, long inode, long pos) throws IOException {
        if (this.inode == inode && this.path.equals(path)) {
            this.setPos(pos);
            this.updateFilePos(pos);
            logger.info("Updated position, file: " + path + ", inode: " + inode + ", pos: " + pos);
            return true;
        }
        return false;
    }

    public void updateFilePos(long pos) throws IOException {
        this.raf.seek(pos);
        this.lineReadPos = pos;
        this.bufferPos = -1;
        this.oldBuffer = new byte[0];
    }

    public List<Event> readEvents(int numEvents, boolean backoffWithoutNL, boolean addByteOffset) throws IOException {
        Event event;
        LinkedList events = Lists.newLinkedList();
        for (int i = 0; i < numEvents && (event = this.readEvent(backoffWithoutNL, addByteOffset)) != null; ++i) {
            events.add(event);
        }
        return events;
    }

    private Event readEvent(boolean backoffWithoutNL, boolean addByteOffset) throws IOException {
        Long posTmp = this.getLineReadPos();
        LineResult line = this.readLine();
        if (line == null) {
            return null;
        }
        if (backoffWithoutNL && !line.lineSepInclude) {
            logger.info("Backing off in file without newline: " + this.path + ", inode: " + this.inode + ", pos: " + this.raf.getFilePointer());
            this.updateFilePos(posTmp);
            return null;
        }
        Event event = EventBuilder.withBody((byte[])line.line);
        if (addByteOffset) {
            event.getHeaders().put("byteoffset", posTmp.toString());
        }
        return event;
    }

    private void readFile() throws IOException {
        this.buffer = this.raf.length() - this.raf.getFilePointer() < 8192L ? new byte[(int)(this.raf.length() - this.raf.getFilePointer())] : new byte[8192];
        this.raf.read(this.buffer, 0, this.buffer.length);
        this.bufferPos = 0;
    }

    private byte[] concatByteArrays(byte[] a, int startIdxA, int lenA, byte[] b, int startIdxB, int lenB) {
        byte[] c = new byte[lenA + lenB];
        System.arraycopy(a, startIdxA, c, 0, lenA);
        System.arraycopy(b, startIdxB, c, lenA, lenB);
        return c;
    }

    public LineResult readLine() throws IOException {
        LineResult lineResult = null;
        while (true) {
            if (this.bufferPos == -1) {
                if (this.raf.getFilePointer() < this.raf.length()) {
                    this.readFile();
                } else {
                    if (this.oldBuffer.length <= 0) break;
                    lineResult = new LineResult(false, this.oldBuffer);
                    this.oldBuffer = new byte[0];
                    this.setLineReadPos(this.lineReadPos + (long)lineResult.line.length);
                    break;
                }
            }
            for (int i = this.bufferPos; i < this.buffer.length; ++i) {
                if (this.buffer[i] != 10) continue;
                int oldLen = this.oldBuffer.length;
                int lineLen = i - this.bufferPos;
                if (i > 0 && this.buffer[i - 1] == 13) {
                    --lineLen;
                } else if (this.oldBuffer.length > 0 && this.oldBuffer[this.oldBuffer.length - 1] == 13) {
                    --oldLen;
                }
                lineResult = new LineResult(true, this.concatByteArrays(this.oldBuffer, 0, oldLen, this.buffer, this.bufferPos, lineLen));
                this.setLineReadPos(this.lineReadPos + (long)(this.oldBuffer.length + (i - this.bufferPos + 1)));
                this.oldBuffer = new byte[0];
                if (i + 1 < this.buffer.length) {
                    this.bufferPos = i + 1;
                    break;
                }
                this.bufferPos = -1;
                break;
            }
            if (lineResult != null) break;
            this.oldBuffer = this.concatByteArrays(this.oldBuffer, 0, this.oldBuffer.length, this.buffer, this.bufferPos, this.buffer.length - this.bufferPos);
            this.bufferPos = -1;
        }
        return lineResult;
    }

    public void close() {
        try {
            this.raf.close();
            this.raf = null;
            long now = System.currentTimeMillis();
            this.setLastUpdated(now);
        }
        catch (IOException e) {
            logger.error("Failed closing file: " + this.path + ", inode: " + this.inode, (Throwable)e);
        }
    }

    private class LineResult {
        final boolean lineSepInclude;
        final byte[] line;

        public LineResult(boolean lineSepInclude, byte[] line) {
            this.lineSepInclude = lineSepInclude;
            this.line = line;
        }
    }
}

