/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.http.client.AbstractClientHttpRequestFactoryWrapper;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.JdkClientHttpRequestFactory;
import org.springframework.http.client.JettyClientHttpRequestFactory;
import org.springframework.http.client.ReactorClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class ClientHttpRequestFactoryRuntimeHints
implements RuntimeHintsRegistrar {
    ClientHttpRequestFactoryRuntimeHints() {
    }

    @Override
    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        if (ClassUtils.isPresent("org.springframework.http.client.ClientHttpRequestFactory", classLoader)) {
            this.registerHints(hints.reflection(), classLoader);
        }
    }

    private void registerHints(ReflectionHints hints, ClassLoader classLoader) {
        hints.registerField(this.findField(AbstractClientHttpRequestFactoryWrapper.class, "requestFactory"));
        this.registerClientHttpRequestFactoryHints(hints, classLoader, "org.apache.hc.client5.http.impl.classic.HttpClients", () -> this.registerReflectionHints(hints, HttpComponentsClientHttpRequestFactory.class));
        this.registerClientHttpRequestFactoryHints(hints, classLoader, "org.eclipse.jetty.client.HttpClient", () -> this.registerReflectionHints(hints, JettyClientHttpRequestFactory.class, Long.TYPE));
        this.registerClientHttpRequestFactoryHints(hints, classLoader, "reactor.netty.http.client.HttpClient", () -> this.registerReflectionHints(hints, ReactorClientHttpRequestFactory.class, Long.TYPE));
        this.registerClientHttpRequestFactoryHints(hints, classLoader, "java.net.http.HttpClient", () -> this.registerReflectionHints(hints, JdkClientHttpRequestFactory.class));
        hints.registerType(SimpleClientHttpRequestFactory.class, typeHint -> {
            typeHint.onReachableType(HttpURLConnection.class);
            this.registerReflectionHints(hints, SimpleClientHttpRequestFactory.class);
        });
    }

    private void registerClientHttpRequestFactoryHints(ReflectionHints hints, ClassLoader classLoader, String className, Runnable action) {
        hints.registerTypeIfPresent(classLoader, className, typeHint -> {
            typeHint.onReachableType(TypeReference.of(className));
            action.run();
        });
    }

    private void registerReflectionHints(ReflectionHints hints, Class<? extends ClientHttpRequestFactory> requestFactoryType) {
        this.registerReflectionHints(hints, requestFactoryType, Integer.TYPE);
    }

    private void registerReflectionHints(ReflectionHints hints, Class<? extends ClientHttpRequestFactory> requestFactoryType, Class<?> readTimeoutType) {
        this.registerMethod(hints, requestFactoryType, "setConnectTimeout", Integer.TYPE);
        this.registerMethod(hints, requestFactoryType, "setReadTimeout", readTimeoutType);
    }

    private void registerMethod(ReflectionHints hints, Class<? extends ClientHttpRequestFactory> requestFactoryType, String methodName, Class<?> ... parameterTypes) {
        Method method = ReflectionUtils.findMethod(requestFactoryType, methodName, parameterTypes);
        if (method != null) {
            hints.registerMethod(method, ExecutableMode.INVOKE);
        }
    }

    private Field findField(Class<?> type, String name) {
        Field field = ReflectionUtils.findField(type, name);
        Assert.state(field != null, () -> "Unable to find field '%s' on %s".formatted(type.getName(), name));
        return field;
    }
}

