/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk.client;

import java.util.HashSet;
import java.util.Set;
import org.I0Itec.zkclient.IZkConnection;
import org.I0Itec.zkclient.serialize.SerializableSerializer;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.helix.HelixException;
import org.apache.helix.manager.zk.BasicZkSerializer;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.manager.zk.client.SharedZkClient;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZkConnectionManager
extends ZkClient {
    private static Logger LOG = LoggerFactory.getLogger(ZkConnectionManager.class);
    private static final String MONITOR_TYPE = "ZkConnectionManager";
    private final String _monitorKey;
    private final Set<Watcher> _sharedWatchers = new HashSet<Watcher>();

    protected ZkConnectionManager(IZkConnection zkConnection, long connectionTimeout, String monitorKey) {
        super(zkConnection, (int)connectionTimeout, Integer.MAX_VALUE, new BasicZkSerializer((ZkSerializer)new SerializableSerializer()), MONITOR_TYPE, monitorKey, null, true);
        this._monitorKey = monitorKey;
        LOG.info("ZkConnection {} was created for sharing.", (Object)this._monitorKey);
    }

    protected synchronized boolean registerWatcher(Watcher watcher) {
        if (this.isClosed()) {
            throw new HelixException("Cannot add watcher to a closed client.");
        }
        return this._sharedWatchers.add(watcher);
    }

    protected synchronized int unregisterWatcher(Watcher watcher) {
        this._sharedWatchers.remove(watcher);
        return this._sharedWatchers.size();
    }

    @Override
    public void process(WatchedEvent event) {
        super.process(event);
        this.forwardingEvent(event);
    }

    private synchronized void forwardingEvent(WatchedEvent event) {
        if (this._sharedWatchers == null || this._sharedWatchers.isEmpty()) {
            return;
        }
        for (Watcher watcher : this._sharedWatchers) {
            watcher.process(event);
        }
    }

    @Override
    public void close() {
        this.close(false);
    }

    protected synchronized void close(boolean skipIfWatched) {
        this.cleanupInactiveWatchers();
        if (this._sharedWatchers.size() > 0) {
            if (skipIfWatched) {
                LOG.debug("Skip closing ZkConnection due to existing watchers. Watcher count {}.", (Object)this._sharedWatchers.size());
                return;
            }
            throw new HelixException("Cannot close the connection when there are still shared watchers listen on the event.");
        }
        super.close();
        LOG.info("ZkConnection {} was closed.", (Object)this._monitorKey);
    }

    private void cleanupInactiveWatchers() {
        HashSet<Watcher> closedWatchers = new HashSet<Watcher>();
        for (Watcher watcher : this._sharedWatchers) {
            if (!(watcher instanceof SharedZkClient) || !((SharedZkClient)watcher).isClosed()) continue;
            closedWatchers.add(watcher);
        }
        this._sharedWatchers.removeAll(closedWatchers);
    }
}

