/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorSelector;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.nio.transport.UDPNIOConnection;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;
import org.glassfish.grizzly.utils.Futures;

public class UDPNIOServerConnection
extends UDPNIOConnection {
    private static final Logger LOGGER = Grizzly.logger(UDPNIOServerConnection.class);

    public UDPNIOServerConnection(UDPNIOTransport transport, DatagramChannel channel) {
        super(transport, channel);
    }

    @Override
    public Processor getProcessor() {
        if (this.processor == null) {
            return this.transport.getProcessor();
        }
        return this.processor;
    }

    @Override
    public ProcessorSelector getProcessorSelector() {
        if (this.processorSelector == null) {
            return this.transport.getProcessorSelector();
        }
        return this.processorSelector;
    }

    public void register() throws IOException {
        FutureImpl future = Futures.createSafeFuture();
        this.transport.getNIOChannelDistributor().registerServiceChannelAsync(this.channel, 1, this, Futures.toCompletionHandler(future, ((UDPNIOTransport)this.transport).registerChannelCompletionHandler));
        try {
            future.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new IOException("Error registering server channel key", e);
        }
        this.notifyReady();
    }

    @Override
    public void close(CompletionHandler<Closeable> completionHandler) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("UDPNIOServerConnection might be only closed by calling unbind().");
        }
        if (completionHandler != null) {
            completionHandler.completed(this);
        }
    }

    public void unbind(CompletionHandler<Closeable> completionHandler) {
        super.close(completionHandler);
    }

    @Override
    protected void preClose() {
        ((UDPNIOTransport)this.transport).unbind(this);
        super.preClose();
    }
}

