/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.json.instance;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.helix.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class InstanceInfo {
    private static final Logger _logger = LoggerFactory.getLogger(InstanceInfo.class);
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="liveInstance")
    private final ZNRecord liveInstance;
    @JsonProperty(value="config")
    private final ZNRecord instanceConfig;
    @JsonProperty(value="partitions")
    private final List<String> partitions;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="resources")
    private final List<String> resources;
    @JsonProperty(value="health")
    private final boolean isHealth;
    @JsonProperty(value="failedHealthChecks")
    private final List<String> failedHealthChecks;

    private InstanceInfo(Builder builder) {
        this.id = builder.id;
        this.liveInstance = builder.liveInstance;
        this.instanceConfig = builder.instanceConfig;
        this.partitions = builder.partitions;
        this.resources = builder.resources;
        this.isHealth = builder.isHealth;
        this.failedHealthChecks = builder.failedHealthChecks;
    }

    public static final class Builder {
        private String id;
        private ZNRecord liveInstance;
        private ZNRecord instanceConfig;
        private List<String> partitions;
        private List<String> resources;
        private boolean isHealth;
        private List<String> failedHealthChecks;

        public Builder(String id) {
            this.id = id;
        }

        public Builder liveInstance(ZNRecord liveInstance) {
            this.liveInstance = liveInstance;
            return this;
        }

        public Builder instanceConfig(ZNRecord instanceConfig) {
            this.instanceConfig = instanceConfig;
            return this;
        }

        public Builder partitions(List<String> partitions) {
            this.partitions = partitions;
            return this;
        }

        public Builder resources(List<String> resources) {
            this.resources = resources;
            return this;
        }

        public Builder healthStatus(Map<String, Boolean> healthChecks) {
            this.failedHealthChecks = new ArrayList<String>();
            for (String healthCheck : healthChecks.keySet()) {
                if (healthChecks.get(healthCheck).booleanValue()) continue;
                _logger.warn("Health Check {} failed", (Object)healthCheck);
                this.failedHealthChecks.add(healthCheck);
            }
            this.isHealth = this.failedHealthChecks.isEmpty();
            return this;
        }

        public Builder healthStatus(boolean isHealth) {
            this.isHealth = isHealth;
            return this;
        }

        public InstanceInfo build() {
            return new InstanceInfo(this);
        }
    }
}

