/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.monitoring;

import java.util.Map;
import jersey.repackaged.com.google.common.collect.Maps;
import org.glassfish.jersey.server.internal.monitoring.ExecutionStatisticsImpl;
import org.glassfish.jersey.server.internal.monitoring.MonitoringUtils;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.monitoring.ExecutionStatistics;
import org.glassfish.jersey.server.monitoring.ResourceMethodStatistics;

final class ResourceMethodStatisticsImpl
implements ResourceMethodStatistics {
    private final ExecutionStatistics resourceMethodExecutionStatistics;
    private final ExecutionStatistics requestExecutionStatistics;
    private final ResourceMethod resourceMethod;

    private ResourceMethodStatisticsImpl(ResourceMethod resourceMethod, ExecutionStatistics resourceMethodExecutionStatistics, ExecutionStatistics requestExecutionStatistics) {
        this.resourceMethod = resourceMethod;
        this.resourceMethodExecutionStatistics = resourceMethodExecutionStatistics;
        this.requestExecutionStatistics = requestExecutionStatistics;
    }

    @Override
    public ExecutionStatistics getRequestStatistics() {
        return this.requestExecutionStatistics;
    }

    @Override
    public ExecutionStatistics getMethodStatistics() {
        return this.resourceMethodExecutionStatistics;
    }

    @Override
    public ResourceMethod getResourceMethod() {
        return this.resourceMethod;
    }

    @Override
    public ResourceMethodStatistics snapshot() {
        return this;
    }

    static class Builder {
        private final ResourceMethod resourceMethod;
        private ExecutionStatisticsImpl.Builder resourceMethodExecutionStatisticsBuilder;
        private ExecutionStatisticsImpl.Builder requestExecutionStatisticsBuilder;
        private ResourceMethodStatisticsImpl cached;

        Builder(ResourceMethod resourceMethod) {
            this.resourceMethod = resourceMethod;
        }

        ResourceMethodStatisticsImpl build() {
            if (this.cached != null) {
                return this.cached;
            }
            ExecutionStatistics methodStats = this.resourceMethodExecutionStatisticsBuilder == null ? ExecutionStatisticsImpl.EMPTY : this.resourceMethodExecutionStatisticsBuilder.build();
            ExecutionStatistics requestStats = this.requestExecutionStatisticsBuilder == null ? ExecutionStatisticsImpl.EMPTY : this.requestExecutionStatisticsBuilder.build();
            ResourceMethodStatisticsImpl stats = new ResourceMethodStatisticsImpl(this.resourceMethod, methodStats, requestStats);
            if (MonitoringUtils.isCacheable(methodStats)) {
                this.cached = stats;
            }
            return stats;
        }

        void addResourceMethodExecution(long methodStartTime, long methodDuration, long requestStartTime, long requestDuration) {
            this.cached = null;
            if (this.resourceMethodExecutionStatisticsBuilder == null) {
                this.resourceMethodExecutionStatisticsBuilder = new ExecutionStatisticsImpl.Builder();
            }
            this.resourceMethodExecutionStatisticsBuilder.addExecution(methodStartTime, methodDuration);
            if (this.requestExecutionStatisticsBuilder == null) {
                this.requestExecutionStatisticsBuilder = new ExecutionStatisticsImpl.Builder();
            }
            this.requestExecutionStatisticsBuilder.addExecution(requestStartTime, requestDuration);
        }
    }

    static class Factory {
        private final Map<String, Builder> stringToMethodsBuilders = Maps.newHashMap();

        Factory() {
        }

        Builder getOrCreate(ResourceMethod resourceMethod) {
            String methodUniqueId = MonitoringUtils.getMethodUniqueId(resourceMethod);
            if (!this.stringToMethodsBuilders.containsKey(methodUniqueId)) {
                this.stringToMethodsBuilders.put(methodUniqueId, new Builder(resourceMethod));
            }
            return this.stringToMethodsBuilders.get(methodUniqueId);
        }
    }
}

